/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.utils.manifest;

import java.util.ArrayList;
import org.apache.felix.utils.manifest.Attribute;
import org.apache.felix.utils.manifest.Clause;
import org.apache.felix.utils.manifest.Directive;

public final class Parser {
    private static final char EOF = '\uffff';
    private static final int CLAUSE_START = 0;
    private static final int PARAMETER_START = 1;
    private static final int KEY = 2;
    private static final int DIRECTIVE_OR_TYPEDATTRIBUTE = 4;
    private static final int ARGUMENT = 8;
    private static final int VALUE = 16;

    private Parser() {
    }

    private static char charAt(int pos, String headers, int length) {
        if (pos >= length) {
            return '\uffff';
        }
        return headers.charAt(pos);
    }

    public static Clause[] parseHeader(String header) throws IllegalArgumentException {
        ArrayList<Clause> clauses = new ArrayList<Clause>();
        if (header != null) {
            if (header.length() == 0) {
                throw new IllegalArgumentException("The header cannot be an empty string.");
            }
            String key = null;
            Object attr = null;
            String value = null;
            String type = null;
            boolean isAttribute = true;
            ArrayList<String> paths = new ArrayList<String>();
            ArrayList<Attribute> attrs = new ArrayList<Attribute>();
            ArrayList<Directive> dirs = new ArrayList<Directive>();
            int state = 0;
            int currentPosition = 0;
            int startPosition = 0;
            int length = header.length();
            boolean quoted = false;
            boolean escaped = false;
            char currentChar = '\uffff';
            do {
                currentChar = Parser.charAt(currentPosition, header, length);
                switch (state) {
                    case 0: {
                        paths.clear();
                        attrs.clear();
                        dirs.clear();
                        state = 1;
                    }
                    case 1: {
                        startPosition = currentPosition;
                        type = null;
                        state = 2;
                    }
                    case 2: {
                        switch (currentChar) {
                            case ':': 
                            case '=': {
                                key = header.substring(startPosition, currentPosition).trim();
                                startPosition = currentPosition + 1;
                                isAttribute = true;
                                state = currentChar == ':' ? 4 : 8;
                                break;
                            }
                            case ',': 
                            case '\uffff': {
                                paths.add(header.substring(startPosition, currentPosition).trim());
                                for (String string : paths) {
                                    clauses.add(new Clause(string, new Directive[0], new Attribute[0]));
                                }
                                state = 0;
                                break;
                            }
                            case ';': {
                                paths.add(header.substring(startPosition, currentPosition).trim());
                                state = 1;
                                break;
                            }
                        }
                        ++currentPosition;
                        break;
                    }
                    case 4: {
                        switch (currentChar) {
                            case '=': {
                                if (startPosition != currentPosition) {
                                    type = header.substring(startPosition, currentPosition).trim();
                                } else {
                                    isAttribute = false;
                                }
                                state = 8;
                                startPosition = currentPosition + 1;
                                break;
                            }
                        }
                        ++currentPosition;
                        break;
                    }
                    case 8: {
                        if (currentChar == '\"') {
                            quoted = true;
                            ++currentPosition;
                        } else {
                            quoted = false;
                        }
                        if (!Character.isWhitespace(currentChar)) {
                            state = 16;
                            break;
                        }
                        ++currentPosition;
                        break;
                    }
                    case 16: {
                        if (escaped) {
                            escaped = false;
                        } else if (currentChar == '\\') {
                            escaped = true;
                        } else if (quoted && currentChar == '\"') {
                            quoted = false;
                        } else if (!quoted) {
                            switch (currentChar) {
                                case ',': 
                                case ';': 
                                case '\uffff': {
                                    value = header.substring(startPosition, currentPosition).trim();
                                    if (value.startsWith("\"") && value.endsWith("\"")) {
                                        value = value.substring(1, value.length() - 1);
                                    }
                                    if (isAttribute) {
                                        for (Attribute attribute : attrs) {
                                            if (!attribute.getName().equals(key)) continue;
                                            throw new IllegalArgumentException("Duplicate '" + key + "' in: " + header);
                                        }
                                        attrs.add(new Attribute(key, value, type));
                                    } else {
                                        for (Directive directive : dirs) {
                                            if (!directive.getName().equals(key)) continue;
                                            throw new IllegalArgumentException("Duplicate '" + key + "' in: " + header);
                                        }
                                        dirs.add(new Directive(key, value));
                                    }
                                    int n = state = currentChar == ';' ? 1 : 0;
                                    if (state != 0) break;
                                    Directive[] d = dirs.toArray(new Directive[dirs.size()]);
                                    Attribute[] attributeArray = attrs.toArray(new Attribute[attrs.size()]);
                                    for (String path : paths) {
                                        clauses.add(new Clause(path, d, attributeArray));
                                    }
                                    break;
                                }
                            }
                        }
                        ++currentPosition;
                        break;
                    }
                }
            } while (currentChar != 65535);
            if (state > 1) {
                throw new IllegalArgumentException("Unable to parse header: " + header);
            }
        }
        return clauses.toArray(new Clause[clauses.size()]);
    }

    public static Clause[] parseClauses(String[] ss) throws IllegalArgumentException {
        if (ss == null) {
            return null;
        }
        ArrayList<Clause> completeList = new ArrayList<Clause>();
        for (int ssIdx = 0; ssIdx < ss.length; ++ssIdx) {
            String[] pieces = Parser.parseDelimitedString(ss[ssIdx], ";");
            int pathCount = 0;
            for (int pieceIdx = 0; pieceIdx < pieces.length && pieces[pieceIdx].indexOf(61) < 0; ++pieceIdx) {
                ++pathCount;
            }
            if (pathCount == 0) {
                throw new IllegalArgumentException("No path specified on clause: " + ss[ssIdx]);
            }
            Directive[] dirs = new Directive[pieces.length - pathCount];
            Attribute[] attrs = new Attribute[pieces.length - pathCount];
            int dirCount = 0;
            int attrCount = 0;
            int idx = -1;
            String sep = null;
            for (int pieceIdx = pathCount; pieceIdx < pieces.length; ++pieceIdx) {
                idx = pieces[pieceIdx].indexOf(":=");
                if (idx >= 0) {
                    sep = ":=";
                } else {
                    idx = pieces[pieceIdx].indexOf("=");
                    if (idx >= 0) {
                        sep = "=";
                    } else {
                        throw new IllegalArgumentException("Not a directive/attribute: " + ss[ssIdx]);
                    }
                }
                String key = pieces[pieceIdx].substring(0, idx).trim();
                String value = pieces[pieceIdx].substring(idx + sep.length()).trim();
                if (value.startsWith("\"") && value.endsWith("\"")) {
                    value = value.substring(1, value.length() - 1);
                }
                if (sep.equals(":=")) {
                    dirs[dirCount++] = new Directive(key, value);
                    continue;
                }
                int columnIdx = key.indexOf(58);
                attrs[attrCount++] = columnIdx > 1 ? new Attribute(key.substring(0, columnIdx), value, key.substring(columnIdx + 1)) : new Attribute(key, value);
            }
            Directive[] dirsFinal = new Directive[dirCount];
            System.arraycopy(dirs, 0, dirsFinal, 0, dirCount);
            Attribute[] attrsFinal = new Attribute[attrCount];
            System.arraycopy(attrs, 0, attrsFinal, 0, attrCount);
            Clause[] pkgs = new Clause[pathCount];
            for (int pkgIdx = 0; pkgIdx < pathCount; ++pkgIdx) {
                pkgs[pkgIdx] = new Clause(pieces[pkgIdx], dirsFinal, attrsFinal);
                completeList.add(pkgs[pkgIdx]);
            }
        }
        Clause[] pkgs = completeList.toArray(new Clause[completeList.size()]);
        return pkgs;
    }

    public static String[] parseDelimitedString(String value, String delim) {
        return Parser.parseDelimitedString(value, delim, true);
    }

    public static String[] parseDelimitedString(String value, String delim, boolean trim) {
        String s;
        if (value == null) {
            value = "";
        }
        ArrayList<String> list = new ArrayList<String>();
        int CHAR = 1;
        int DELIMITER = 2;
        int STARTQUOTE = 4;
        int ENDQUOTE = 8;
        StringBuffer sb = new StringBuffer();
        int expecting = CHAR | DELIMITER | STARTQUOTE;
        boolean isEscaped = false;
        for (int i = 0; i < value.length(); ++i) {
            boolean isDelimiter;
            char c = value.charAt(i);
            boolean bl = isDelimiter = delim.indexOf(c) >= 0;
            if (!isEscaped && c == '\\') {
                isEscaped = true;
                continue;
            }
            if (isEscaped) {
                sb.append(c);
            } else if (isDelimiter && (expecting & DELIMITER) > 0) {
                list.add(trim ? sb.toString().trim() : sb.toString());
                sb.delete(0, sb.length());
                expecting = CHAR | DELIMITER | STARTQUOTE;
            } else if (c == '\"' && (expecting & STARTQUOTE) > 0) {
                sb.append(c);
                expecting = CHAR | ENDQUOTE;
            } else if (c == '\"' && (expecting & ENDQUOTE) > 0) {
                sb.append(c);
                expecting = CHAR | STARTQUOTE | DELIMITER;
            } else if ((expecting & CHAR) > 0) {
                sb.append(c);
            } else {
                throw new IllegalArgumentException("Invalid delimited string: " + value);
            }
            isEscaped = false;
        }
        String string = s = trim ? sb.toString().trim() : sb.toString();
        if (s.length() > 0) {
            list.add(s);
        }
        return list.toArray(new String[list.size()]);
    }
}

