/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.git.http;

import io.fabric8.api.FabricException;
import io.fabric8.api.FabricService;
import io.fabric8.api.RuntimeProperties;
import io.fabric8.api.TargetContainer;
import io.fabric8.api.jcip.ThreadSafe;
import io.fabric8.api.scr.AbstractComponent;
import io.fabric8.api.scr.ValidatingReference;
import io.fabric8.git.GitNode;
import io.fabric8.git.GitService;
import io.fabric8.git.http.GitSecureHttpContext;
import io.fabric8.groups.Group;
import io.fabric8.groups.GroupListener;
import io.fabric8.groups.NodeState;
import io.fabric8.groups.internal.ZooKeeperGroup;
import io.fabric8.zookeeper.ZkPath;
import io.fabric8.zookeeper.utils.ZooKeeperUtils;
import java.io.File;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.servlet.Servlet;
import org.apache.curator.framework.CuratorFramework;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.eclipse.jgit.api.CloneCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.http.server.GitServlet;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.http.HttpContext;
import org.osgi.service.http.HttpService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
@Component(name="io.fabric8.git.server", label="Fabric8 Git HTTP Server Registration Handler", policy=ConfigurationPolicy.OPTIONAL, immediate=true, metatype=true)
public final class GitHttpServerRegistrationHandler
extends AbstractComponent
implements GroupListener<GitNode> {
    private static final Logger LOGGER = LoggerFactory.getLogger(GitHttpServerRegistrationHandler.class);
    private static final String GIT_PID = "io.fabric8.git";
    private static final String REALM_PROPERTY_NAME = "realm";
    private static final String ROLE_PROPERTY_NAME = "role";
    private static final String DEFAULT_ROLE = "admin";
    private static final Map<TargetContainer, String> defaultRealms;
    @Reference(referenceInterface=HttpService.class)
    private final ValidatingReference<HttpService> httpService = new ValidatingReference();
    @Reference(referenceInterface=ConfigurationAdmin.class)
    private final ValidatingReference<ConfigurationAdmin> configAdmin = new ValidatingReference();
    @Reference(referenceInterface=RuntimeProperties.class)
    private final ValidatingReference<RuntimeProperties> runtimeProperties = new ValidatingReference();
    @Reference(referenceInterface=CuratorFramework.class)
    private final ValidatingReference<CuratorFramework> curator = new ValidatingReference();
    @Reference(referenceInterface=GitService.class)
    private final ValidatingReference<GitService> gitService = new ValidatingReference();
    @Reference
    private FabricService fabricService;
    private volatile Group<GitNode> group;
    private volatile String gitRemoteUrl;

    @Activate
    void activate(Map<String, ?> configuration) {
        RuntimeProperties sysprops = (RuntimeProperties)this.runtimeProperties.get();
        String realm = this.getConfiguredRealm(sysprops, configuration);
        String role = this.getConfiguredRole(sysprops, configuration);
        this.registerServlet(sysprops, realm, role);
        this.activateComponent();
        this.group = new ZooKeeperGroup((CuratorFramework)this.curator.get(), ZkPath.GIT.getPath(new String[0]), GitNode.class);
        this.group.add((GroupListener)this);
        this.group.update((NodeState)this.createState());
        this.group.start();
    }

    @Deactivate
    void deactivate() {
        this.deactivateComponent();
        this.unregisterServlet();
        try {
            if (this.group != null) {
                this.group.close();
            }
        }
        catch (Exception e) {
            LOGGER.warn("Failed to remove git server from registry.", (Throwable)e);
        }
    }

    public void groupEvent(Group<GitNode> group, GroupListener.GroupEvent event) {
        if (this.isValid()) {
            switch (event) {
                case CONNECTED: 
                case CHANGED: {
                    this.updateMasterUrl(group);
                    break;
                }
            }
        }
    }

    private String getConfiguredRealm(RuntimeProperties sysprops, Map<String, ?> configuration) {
        String realm = (String)configuration.get(REALM_PROPERTY_NAME);
        if (realm == null) {
            TargetContainer targetContainer = TargetContainer.getTargetContainer((RuntimeProperties)sysprops);
            realm = defaultRealms.get(targetContainer);
        }
        return realm;
    }

    private String getConfiguredRole(RuntimeProperties sysprops, Map<String, ?> configuration) {
        return configuration.containsKey(ROLE_PROPERTY_NAME) ? (String)configuration.get(ROLE_PROPERTY_NAME) : DEFAULT_ROLE;
    }

    private void updateMasterUrl(Group<GitNode> group) {
        if (group.isMaster()) {
            LOGGER.debug("Git repo is the master");
        } else {
            LOGGER.debug("Git repo is not the master");
        }
        try {
            GitNode state = this.createState();
            group.update((NodeState)state);
            String url = state.getUrl();
            this.gitRemoteUrl = ZooKeeperUtils.getSubstitutedData((CuratorFramework)((CuratorFramework)this.curator.get()), (String)url);
            if (group.isMaster()) {
                this.updateConfigAdmin();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void registerServlet(RuntimeProperties sysprops, String realm, String role) {
        String servletBasePath = sysprops.getProperty("karaf.data") + File.separator + "git" + File.separator + "servlet" + File.separator;
        String fabricRepoPath = servletBasePath + "fabric";
        try {
            HttpContext base = ((HttpService)this.httpService.get()).createDefaultHttpContext();
            GitSecureHttpContext secure = new GitSecureHttpContext(base, (CuratorFramework)this.curator.get(), realm, role);
            File fabricRoot = new File(fabricRepoPath);
            if (!fabricRoot.exists()) {
                Git localGit = ((GitService)this.gitService.get()).get();
                ((CloneCommand)Git.cloneRepository().setTimeout(10)).setBare(true).setNoCheckout(true).setCloneAllBranches(true).setDirectory(fabricRoot).setURI(localGit.getRepository().getDirectory().toURI().toString()).call().getRepository().close();
            }
            Hashtable<String, String> initParams = new Hashtable<String, String>();
            ((Dictionary)initParams).put("base-path", servletBasePath);
            ((Dictionary)initParams).put("repository-root", servletBasePath);
            ((Dictionary)initParams).put("export-all", "true");
            ((HttpService)this.httpService.get()).registerServlet("/git", (Servlet)new GitServlet(), initParams, (HttpContext)secure);
        }
        catch (Throwable t) {
            throw FabricException.launderThrowable((Throwable)t);
        }
    }

    private void unregisterServlet() {
        ((HttpService)this.httpService.get()).unregister("/git");
    }

    private void updateConfigAdmin() {
        try {
            Configuration conf = ((ConfigurationAdmin)this.configAdmin.get()).getConfiguration(GIT_PID);
            if (conf == null) {
                LOGGER.warn("No configuration for pid io.fabric8.git");
            } else {
                Hashtable<String, String> properties = conf.getProperties();
                if (properties == null) {
                    properties = new Hashtable<String, String>();
                }
                ((Dictionary)properties).put("fabric.git.url", this.gitRemoteUrl);
                conf.update(properties);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Setting pid io.fabric8.git config admin to: " + properties);
                }
            }
        }
        catch (Throwable e) {
            LOGGER.error("Could not load config admin for pid io.fabric8.git. Reason: " + e, e);
        }
    }

    private GitNode createState() {
        RuntimeProperties sysprops = (RuntimeProperties)this.runtimeProperties.get();
        TargetContainer runtimeType = TargetContainer.getTargetContainer((RuntimeProperties)sysprops);
        String context = runtimeType == TargetContainer.KARAF ? "" : "/fabric";
        String karafName = sysprops.getProperty("karaf.name");
        String fabricRepoUrl = "${zk:" + karafName + "/http}" + context + "/git/fabric/";
        GitNode state = new GitNode(karafName);
        state.setId("fabric-repo");
        if (this.group != null && this.group.isMaster()) {
            state.setUrl(fabricRepoUrl);
        }
        return state;
    }

    void bindConfigAdmin(ConfigurationAdmin service) {
        this.configAdmin.bind((Object)service);
    }

    void unbindConfigAdmin(ConfigurationAdmin service) {
        this.configAdmin.unbind((Object)service);
    }

    void bindCurator(CuratorFramework curator) {
        this.curator.bind((Object)curator);
    }

    void unbindCurator(CuratorFramework curator) {
        this.curator.unbind((Object)curator);
    }

    void bindRuntimeProperties(RuntimeProperties service) {
        this.runtimeProperties.bind((Object)service);
    }

    void unbindRuntimeProperties(RuntimeProperties service) {
        this.runtimeProperties.unbind((Object)service);
    }

    void bindHttpService(HttpService service) {
        this.httpService.bind((Object)service);
    }

    void unbindHttpService(HttpService service) {
        this.httpService.unbind((Object)service);
    }

    void bindGitService(GitService service) {
        this.gitService.bind((Object)service);
    }

    void unbindGitService(GitService service) {
        this.gitService.unbind((Object)service);
    }

    static {
        HashMap<TargetContainer, String> realms = new HashMap<TargetContainer, String>();
        realms.put(TargetContainer.KARAF, "karaf");
        realms.put(TargetContainer.TOMCAT, "fabric");
        realms.put(TargetContainer.WILDFLY, "fabric-domain");
        defaultRealms = Collections.unmodifiableMap(realms);
    }

    protected void bindFabricService(FabricService fabricService) {
        this.fabricService = fabricService;
    }

    protected void unbindFabricService(FabricService fabricService) {
        if (this.fabricService == fabricService) {
            this.fabricService = null;
        }
    }
}

