/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.docker.api;

import io.fabric8.docker.api.Docker;
import org.jboss.resteasy.client.jaxrs.ResteasyClient;
import org.jboss.resteasy.client.jaxrs.ResteasyClientBuilder;
import org.jboss.resteasy.client.jaxrs.ResteasyWebTarget;
import org.jboss.resteasy.plugins.providers.jackson.Jackson2JsonpInterceptor;
import org.jboss.resteasy.plugins.providers.jackson.ResteasyJackson2Provider;
import org.jboss.resteasy.spi.ResteasyProviderFactory;

public class DockerFactory {
    private String address = "http://localhost:4243";

    public DockerFactory() {
        this.address = "http://localhost:4243";
        this.findDocker();
        this.init();
    }

    public DockerFactory(String address) {
        this.address = address;
        if (DockerFactory.isEmpty(address)) {
            this.findDocker();
        }
        this.init();
    }

    protected void findDocker() {
        String dockerHost = System.getenv("DOCKER_HOST");
        if (DockerFactory.isEmpty(dockerHost)) {
            dockerHost = System.getProperty("docker.host");
        }
        if (!DockerFactory.isEmpty(dockerHost)) {
            this.address = dockerHost.startsWith("tcp:") ? "http:" + dockerHost.substring(4) : dockerHost;
        }
    }

    private void init() {
    }

    public String toString() {
        return "DockerFactory{" + this.address + '}';
    }

    public Docker createDocker() {
        ResteasyProviderFactory providerFactory = ResteasyProviderFactory.getInstance();
        providerFactory.register((Class)ResteasyJackson2Provider.class);
        providerFactory.register((Class)Jackson2JsonpInterceptor.class);
        ResteasyClientBuilder builder = new ResteasyClientBuilder();
        builder.providerFactory(providerFactory);
        ResteasyClient client = builder.build();
        ResteasyWebTarget target = (ResteasyWebTarget)client.target(this.address);
        return target.proxy(Docker.class);
    }

    public String getDockerHost() {
        String answer = this.address;
        int idx = answer.lastIndexOf(":");
        if (idx > 0) {
            answer = answer.substring(0, idx);
        }
        if ((idx = answer.lastIndexOf(":")) > 0) {
            answer = answer.substring(idx + 1);
        }
        if ((idx = answer.lastIndexOf("/")) > 0) {
            answer = answer.substring(idx + 1);
        }
        return answer;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
        if (DockerFactory.isEmpty(address)) {
            this.findDocker();
        }
    }

    protected static boolean isEmpty(String text) {
        return text == null || text.length() == 0;
    }
}

