/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.service.ssh;

import io.fabric8.api.AutoScaleRequest;
import io.fabric8.api.Container;
import io.fabric8.api.ContainerAutoScaler;
import io.fabric8.api.Containers;
import io.fabric8.api.CreateContainerOptions;
import io.fabric8.api.FabricRequirements;
import io.fabric8.api.FabricService;
import io.fabric8.api.NameValidator;
import io.fabric8.api.ProfileRequirements;
import io.fabric8.api.SshHostConfiguration;
import io.fabric8.api.SshScalingRequirements;
import io.fabric8.common.util.Filter;
import io.fabric8.common.util.Filters;
import io.fabric8.service.ssh.CreateSshContainerOptions;
import io.fabric8.service.ssh.SshContainerProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SshAutoScaler
implements ContainerAutoScaler {
    private static final transient Logger LOG = LoggerFactory.getLogger(SshAutoScaler.class);
    private final SshContainerProvider containerProvider;

    public SshAutoScaler(SshContainerProvider containerProvider) {
        this.containerProvider = containerProvider;
    }

    public int getWeight() {
        return 50;
    }

    public void createContainers(AutoScaleRequest request) throws Exception {
        int count = request.getDelta();
        String profile = request.getProfile();
        String version = request.getVersion();
        FabricService fabricService = request.getFabricService();
        Container[] containers = fabricService.getContainers();
        for (int i = 0; i < count; ++i) {
            CreateSshContainerOptions.Builder builder = null;
            NameValidator nameValidator = Containers.createNameValidator((Container[])containers);
            String name = Containers.createContainerName((Container[])containers, (String)profile, (String)this.containerProvider.getScheme(), (NameValidator)nameValidator);
            if (fabricService != null) {
                builder = this.createAutoScaleOptions(request, fabricService, name);
            }
            if (builder == null) continue;
            CreateSshContainerOptions.Builder configuredBuilder = (CreateSshContainerOptions.Builder)((CreateSshContainerOptions.Builder)((CreateSshContainerOptions.Builder)builder.number(1)).version(version)).profiles(profile);
            CreateSshContainerOptions options = ((CreateSshContainerOptions.Builder)configuredBuilder.name(name)).build();
            LOG.info("Creating container name " + name + " version " + version + " profile " + profile + " " + count + " container(s)");
            fabricService.createContainers((CreateContainerOptions)options);
        }
    }

    protected CreateSshContainerOptions.Builder createAutoScaleOptions(AutoScaleRequest request, FabricService fabricService, String containerName) {
        ProfileRequirements profileRequirements;
        SshScalingRequirements sshScalingRequirements;
        CreateSshContainerOptions.Builder builder = CreateSshContainerOptions.builder();
        FabricRequirements requirements = request.getFabricRequirements();
        List<SshHostConfiguration> sshHostConfigurations = this.filterHosts(requirements, sshScalingRequirements = (profileRequirements = request.getProfileRequirements()).getSshScalingRequirements());
        SshHostConfiguration sshHostConfig = (SshHostConfiguration)Filters.matchRandomElement(sshHostConfigurations);
        if (sshHostConfig == null) {
            LOG.warn("Could not create version " + request.getVersion() + " profile " + request.getProfile() + " as no matching hosts could be found for " + sshScalingRequirements);
            return null;
        }
        builder.configure(sshHostConfig, requirements, profileRequirements, containerName);
        String zookeeperUrl = fabricService.getZookeeperUrl();
        String zookeeperPassword = fabricService.getZookeeperPassword();
        if (builder.getProxyUri() == null) {
            builder.proxyUri(fabricService.getMavenRepoURI());
        }
        return (CreateSshContainerOptions.Builder)((CreateSshContainerOptions.Builder)builder.zookeeperUrl(zookeeperUrl)).zookeeperPassword(zookeeperPassword);
    }

    protected List<SshHostConfiguration> filterHosts(FabricRequirements requirements, SshScalingRequirements sshScalingRequirements) {
        ArrayList<SshHostConfiguration> answer = new ArrayList<SshHostConfiguration>();
        Map hosts = requirements.getSshHostsMap();
        if (hosts != null) {
            Filter filter = Filters.createStringFilters((Iterable)sshScalingRequirements.getHostPatterns());
            Set entries = hosts.entrySet();
            for (Map.Entry entry : entries) {
                String hostAlias = (String)entry.getKey();
                if (!filter.matches((Object)hostAlias)) continue;
                SshHostConfiguration config = (SshHostConfiguration)entry.getValue();
                answer.add(config);
            }
        }
        return answer;
    }

    public void destroyContainers(String profile, int count, List<Container> containers) {
    }
}

