/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.service.jclouds;

import io.fabric8.api.jcip.ThreadSafe;
import io.fabric8.api.scr.AbstractComponent;
import io.fabric8.api.scr.ValidatingReference;
import io.fabric8.zookeeper.ZkPath;
import io.fabric8.zookeeper.utils.ZooKeeperUtils;
import java.util.Dictionary;
import java.util.Enumeration;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.state.ConnectionState;
import org.apache.curator.framework.state.ConnectionStateListener;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
@Component(name="io.fabric8.jclouds.bridge", label="Fabric8 Jclouds Service Bridge", immediate=true, metatype=false)
@Service(value={ConnectionStateListener.class})
public final class CloudProviderBridge
extends AbstractComponent
implements ConnectionStateListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(CloudProviderBridge.class);
    private static final String COMPUTE_FILTER = "(service.factoryPid=org.jclouds.compute)";
    private static final String BLOBSTORE_FILTER = "(service.factoryPid=org.jclouds.blobstore)";
    @Reference(referenceInterface=ConfigurationAdmin.class)
    private final ValidatingReference<ConfigurationAdmin> configAdmin = new ValidatingReference();
    @Reference(referenceInterface=CuratorFramework.class)
    private final ValidatingReference<CuratorFramework> curator = new ValidatingReference();

    @Activate
    void activate() {
        this.activateComponent();
    }

    @Deactivate
    void deactivate() {
        this.deactivateComponent();
    }

    public void stateChanged(CuratorFramework client, ConnectionState newState) {
        if (this.isValid()) {
            switch (newState) {
                case CONNECTED: 
                case RECONNECTED: {
                    this.curator.bind((Object)client);
                    this.onConnected();
                    break;
                }
                default: {
                    this.onDisconnected();
                }
            }
        }
    }

    private void onConnected() {
        this.registerServices(COMPUTE_FILTER);
        this.registerServices(BLOBSTORE_FILTER);
    }

    private void onDisconnected() {
    }

    private void registerServices(String filter) {
        try {
            Configuration[] configurations = ((ConfigurationAdmin)this.configAdmin.get()).listConfigurations(filter);
            if (configurations != null) {
                for (Configuration configuration : configurations) {
                    String credential;
                    Dictionary properties = configuration.getProperties();
                    if (properties == null) continue;
                    String name = properties.get("name") != null ? String.valueOf(properties.get("name")) : null;
                    String identity = properties.get("identity") != null ? String.valueOf(properties.get("identity")) : null;
                    String string = credential = properties.get("credential") != null ? String.valueOf(properties.get("credential")) : null;
                    if (name == null || identity == null || credential == null || !((CuratorFramework)this.curator.get()).getZookeeperClient().isConnected() || ZooKeeperUtils.exists((CuratorFramework)((CuratorFramework)this.curator.get()), (String)ZkPath.CLOUD_SERVICE.getPath(new String[]{name})) != null) continue;
                    ZooKeeperUtils.create((CuratorFramework)((CuratorFramework)this.curator.get()), (String)ZkPath.CLOUD_SERVICE.getPath(new String[]{name}));
                    Enumeration keys = properties.keys();
                    while (keys.hasMoreElements()) {
                        String key = String.valueOf(keys.nextElement());
                        String value = String.valueOf(properties.get(key));
                        if (key.equals("service.pid") || key.equals("service.factoryPid")) continue;
                        ZooKeeperUtils.setData((CuratorFramework)((CuratorFramework)this.curator.get()), (String)ZkPath.CLOUD_SERVICE_PROPERTY.getPath(new String[]{name, key}), (String)value);
                    }
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to retrieve compute service information from configuration admin.", (Throwable)e);
        }
    }

    void bindConfigAdmin(ConfigurationAdmin service) {
        this.configAdmin.bind((Object)service);
    }

    void unbindConfigAdmin(ConfigurationAdmin service) {
        this.configAdmin.unbind((Object)service);
    }

    void bindCurator(CuratorFramework curator) {
        this.curator.bind((Object)curator);
    }

    void unbindCurator(CuratorFramework curator) {
        this.curator.unbind((Object)curator);
    }
}

