/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.service.jclouds.commands;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.reflect.TypeToken;
import io.fabric8.boot.commands.support.FabricCommand;
import io.fabric8.service.jclouds.ComputeRegistry;
import java.io.PrintStream;
import java.util.List;
import org.apache.felix.gogo.commands.Command;
import org.jclouds.apis.ApiMetadata;
import org.jclouds.apis.Apis;
import org.jclouds.compute.ComputeService;
import org.jclouds.compute.ComputeServiceContext;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.providers.ProviderMetadata;
import org.jclouds.providers.Providers;

@Command(name="cloud-service-list", scope="fabric", description="Lists the cloud providers registered with the fabric.")
public class CloudServiceList
extends FabricCommand {
    public static final String PROVIDERFORMAT = "%-24s %-12s %-24s %-24s";
    private ComputeRegistry computeRegistry;

    protected Object doExecute() throws Exception {
        Iterable providers = Providers.viewableAs((TypeToken)TypeToken.of(ComputeServiceContext.class));
        Iterable apis = Apis.viewableAs((TypeToken)TypeToken.of(ComputeServiceContext.class));
        Iterable providerIds = Iterables.transform((Iterable)providers, (Function)new Function<ProviderMetadata, String>(){

            public String apply(@Nullable ProviderMetadata input) {
                return input.getId();
            }
        });
        Iterable apiIds = Iterables.transform((Iterable)apis, (Function)new Function<ApiMetadata, String>(){

            public String apply(@Nullable ApiMetadata input) {
                return input.getId();
            }
        });
        boolean providerOrApiFound = false;
        if (apiIds != null) {
            providerOrApiFound = true;
            System.out.println("Compute APIs:");
            System.out.println("-------------");
            this.printComputeProvidersOrApis(apiIds, this.computeRegistry.list(), "", System.out);
        }
        if (providers != null) {
            providerOrApiFound = true;
            System.out.println("Compute Providers:");
            System.out.println("-------------");
            this.printComputeProvidersOrApis(providerIds, this.computeRegistry.list(), "", System.out);
        }
        if (!providerOrApiFound) {
            System.out.println("No providers or apis have been found.");
        }
        return null;
    }

    protected void printComputeProvidersOrApis(Iterable<String> providersOrApis, List<ComputeService> computeServices, String indent, PrintStream out) {
        out.println(String.format(PROVIDERFORMAT, "[id]", "[type]", "[local services]", "[fabric services]"));
        for (String providerOrApi : providersOrApis) {
            boolean registered = false;
            StringBuffer localServices = new StringBuffer();
            StringBuffer fabricServices = new StringBuffer();
            localServices.append("[ ");
            fabricServices.append("[ ");
            for (ComputeService computeService : computeServices) {
                if (!computeService.getContext().unwrap().getId().equals(providerOrApi)) continue;
                String name = computeService.getContext().unwrap().getName();
                if (this.getCurator() != null && this.getCurator().getZookeeperClient().isConnected()) {
                    fabricServices.append(name).append(" ");
                    continue;
                }
                localServices.append(name).append(" ");
            }
            localServices.append("]");
            fabricServices.append("]");
            out.println(String.format(PROVIDERFORMAT, providerOrApi, "compute", localServices.toString(), fabricServices.toString()));
        }
    }

    public ComputeRegistry getComputeRegistry() {
        return this.computeRegistry;
    }

    public void setComputeRegistry(ComputeRegistry computeRegistry) {
        this.computeRegistry = computeRegistry;
    }
}

