/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.commands.support;

import io.fabric8.api.Container;
import io.fabric8.api.Profile;
import io.fabric8.api.Version;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public final class CommandUtils {
    private CommandUtils() {
    }

    public static List<Profile> sortProfiles(List<Profile> profiles) {
        if (profiles == null || profiles.size() <= 1) {
            return profiles;
        }
        ArrayList<Profile> sorted = new ArrayList<Profile>(profiles);
        Collections.sort(sorted, new Comparator<Profile>(){

            @Override
            public int compare(Profile p1, Profile p2) {
                if (p1 == null) {
                    return 1;
                }
                if (p2 == null) {
                    return -1;
                }
                return p1.getId().compareTo(p2.getId());
            }
        });
        return Collections.unmodifiableList(sorted);
    }

    public static Container[] sortContainers(Container[] containers) {
        if (containers == null || containers.length <= 1) {
            return containers;
        }
        ArrayList<Container> list = new ArrayList<Container>();
        list.addAll(Arrays.asList(containers));
        Collections.sort(list, new Comparator<Container>(){

            @Override
            public int compare(Container c1, Container c2) {
                if (c1 == null) {
                    return 1;
                }
                if (c2 == null) {
                    return -1;
                }
                if (c1.isRoot() && c2.getParent() != null && c2.getParent().equals(c1)) {
                    return -1;
                }
                if (c2.isRoot() && c1.getParent() != null && c1.getParent().equals(c2)) {
                    return 1;
                }
                if (c1.isRoot() && !c2.isRoot()) {
                    return c1.getId().compareTo(c2.getParent().getId());
                }
                if (!c1.isRoot() && c2.isRoot()) {
                    return c1.getParent().getId().compareTo(c2.getId());
                }
                if (!(c1.isRoot() || c2.isRoot() || c1.getParent().equals(c2.getParent()))) {
                    return c1.getParent().getId().compareTo(c2.getParent().getId());
                }
                return c1.getId().compareTo(c2.getId());
            }
        });
        return list.toArray(new Container[0]);
    }

    public static Container[] filterContainers(Container[] containers, String filter) {
        if (containers == null || containers.length == 0) {
            return containers;
        }
        if (filter == null || filter.trim().length() == 0) {
            return containers;
        }
        ArrayList<Container> list = new ArrayList<Container>();
        block0: for (Container container : containers) {
            if (container.getId().contains(filter)) {
                list.add(container);
                continue;
            }
            for (Profile profile : container.getProfiles()) {
                if (!profile.getId().contains(filter)) continue;
                list.add(container);
                continue block0;
            }
        }
        return list.toArray(new Container[0]);
    }

    public static boolean matchVersion(Container container, Version version) {
        if (version == null) {
            return true;
        }
        return version.equals(container.getVersion());
    }

    public static String status(Container container) {
        String status;
        String string = status = container.isManaged() ? container.getProvisionStatus() : "";
        if (status == null) {
            return "";
        }
        if ((status = status.trim()).length() > 100) {
            return status.substring(0, 100);
        }
        return status;
    }

    public static int countContainersByVersion(Container[] containers, Version version) {
        int answer = 0;
        for (Container container : containers) {
            if (!container.getVersion().getId().equals(version.getId())) continue;
            ++answer;
        }
        return answer;
    }
}

