/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.service.jclouds.firewall;

import io.fabric8.service.jclouds.firewall.RuleType;
import org.jclouds.compute.domain.NodeMetadata;

public class Rule {
    private String source;
    private NodeMetadata destination;
    private int[] ports;
    private RuleType type = RuleType.AUTHORIZE;

    public static Rule create() {
        return new Rule();
    }

    private Rule() {
    }

    public Rule source(String source) {
        this.source = source;
        return this;
    }

    public Rule destination(NodeMetadata destination) {
        this.destination = destination;
        return this;
    }

    public Rule port(int port) {
        this.ports = new int[]{port};
        return this;
    }

    public Rule ports(int ... ports) {
        this.ports = ports;
        return this;
    }

    public Rule portRange(int fromPort, int toPort) {
        int size = toPort - fromPort + 1;
        if (size > 0) {
            this.ports = new int[size];
            for (int i = 0; i < size; ++i) {
                this.ports[i] = fromPort + i;
            }
        }
        return this;
    }

    public Rule authorize() {
        this.type = RuleType.AUTHORIZE;
        return this;
    }

    public Rule revoke() {
        this.type = RuleType.REVOKE;
        return this;
    }

    public Rule flush() {
        this.type = RuleType.FLUSH;
        return this;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public NodeMetadata getDestination() {
        return this.destination;
    }

    public void setDestination(NodeMetadata destination) {
        this.destination = destination;
    }

    public int[] getPorts() {
        return this.ports;
    }

    public void setPorts(int[] ports) {
        this.ports = ports;
    }

    public RuleType getType() {
        return this.type;
    }

    public void setType(RuleType type) {
        this.type = type;
    }
}

