/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.configadmin;

import io.fabric8.api.ContainerRegistration;
import io.fabric8.api.FabricService;
import io.fabric8.api.Profile;
import io.fabric8.api.jcip.ThreadSafe;
import io.fabric8.api.scr.AbstractComponent;
import io.fabric8.api.scr.ValidatingReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.url.URLStreamHandlerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
@Component(name="io.fabric8.configadmin.bridge", label="Fabric8 Config Admin Bridge", metatype=false)
public final class FabricConfigAdminBridge
extends AbstractComponent
implements Runnable {
    public static final String FABRIC_ZOOKEEPER_PID = "fabric.zookeeper.pid";
    public static final String FABRIC_CONFIG_MERGE = "fabric.config.merge";
    public static final String LAST_MODIFIED = "lastModified";
    private static final Logger LOGGER = LoggerFactory.getLogger(FabricConfigAdminBridge.class);
    @Reference(referenceInterface=ConfigurationAdmin.class)
    private final ValidatingReference<ConfigurationAdmin> configAdmin = new ValidatingReference();
    @Reference(referenceInterface=FabricService.class)
    private final ValidatingReference<FabricService> fabricService = new ValidatingReference();
    @Reference(referenceInterface=ContainerRegistration.class)
    private final ValidatingReference<ContainerRegistration> containerRegistration = new ValidatingReference();
    @Reference(referenceInterface=URLStreamHandlerService.class, target="url.handler.protocol=profile")
    private final ValidatingReference<URLStreamHandlerService> urlHandler = new ValidatingReference();
    private final ExecutorService executor = Executors.newSingleThreadExecutor(new NamedThreadFactory("fabric-configadmin"));

    @Activate
    void activate() {
        ((FabricService)this.fabricService.get()).trackConfiguration((Runnable)this);
        this.activateComponent();
        this.submitUpdateJob();
    }

    @Deactivate
    void deactivate() {
        this.deactivateComponent();
        ((FabricService)this.fabricService.get()).untrackConfiguration((Runnable)this);
        this.executor.shutdown();
        try {
            this.executor.awaitTermination(1L, TimeUnit.MINUTES);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.executor.shutdownNow();
    }

    @Override
    public void run() {
        this.submitUpdateJob();
    }

    private void submitUpdateJob() {
        this.executor.submit(new Runnable(){

            @Override
            public void run() {
                if (FabricConfigAdminBridge.this.isValid()) {
                    FabricConfigAdminBridge.this.updateInternal();
                }
            }
        });
    }

    private synchronized void updateInternal() {
        Profile profile = null;
        try {
            profile = ((FabricService)this.fabricService.get()).getCurrentContainer().getOverlayProfile();
        }
        catch (Exception ex) {
            LOGGER.debug("Failed to read container profile. This exception will be ignored..", (Throwable)ex);
            return;
        }
        try {
            Hashtable<String, Object> c;
            Map pidProperties = profile.getConfigurations();
            List<Configuration> configs = this.asList(((ConfigurationAdmin)this.configAdmin.get()).listConfigurations("(fabric.zookeeper.pid=*)"));
            for (String pid : pidProperties.keySet()) {
                if (pid.equals("io.fabric8.agent")) continue;
                c = new Hashtable<String, Object>();
                c.putAll((Map)pidProperties.get(pid));
                this.updateConfig(configs, pid, c);
            }
            for (String pid : pidProperties.keySet()) {
                if (!pid.equals("io.fabric8.agent")) continue;
                c = new Hashtable();
                c.putAll((Map)pidProperties.get(pid));
                c.put("hash", String.valueOf(profile.getProfileHash()));
                this.updateConfig(configs, pid, c);
            }
            for (Configuration config : configs) {
                LOGGER.info("Deleting configuration {}", (Object)config.getPid());
                ((FabricService)this.fabricService.get()).getPortService().unregisterPort(((FabricService)this.fabricService.get()).getCurrentContainer(), config.getPid());
                config.delete();
            }
        }
        catch (Throwable e) {
            if (this.isValid()) {
                LOGGER.warn("Exception when tracking configurations. This exception will be ignored.", e);
            }
            LOGGER.debug("Exception when tracking configurations. This exception will be ignored because services have been unbound in the mean time.", e);
        }
    }

    private void updateConfig(List<Configuration> configs, String pid, Hashtable<String, Object> c) throws Exception {
        Hashtable<String, Object> old;
        String[] p = this.parsePid(pid);
        Configuration config = this.getConfiguration((ConfigurationAdmin)this.configAdmin.get(), pid, p[0], p[1]);
        configs.remove(config);
        Dictionary props = config.getProperties();
        Hashtable<String, Object> hashtable = old = props != null ? new Hashtable<String, Object>() : null;
        if (old != null) {
            Enumeration e = props.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                Object val = props.get(key);
                old.put(key, val);
            }
            old.remove(FABRIC_ZOOKEEPER_PID);
            old.remove("service.pid");
            old.remove("service.factoryPid");
        }
        if (!c.equals(old)) {
            LOGGER.info("Updating configuration {}", (Object)config.getPid());
            c.put(FABRIC_ZOOKEEPER_PID, pid);
            if (config.getBundleLocation() != null) {
                config.setBundleLocation(null);
            }
            if ("true".equals(c.get(FABRIC_CONFIG_MERGE)) && old != null) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("");
                }
                old.putAll(c);
                c = old;
            }
            config.update(c);
        } else if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Ignoring configuration {} (no changes)", (Object)config.getPid());
        }
    }

    private <T> List<T> asList(T ... a) {
        ArrayList l = new ArrayList();
        if (a != null) {
            Collections.addAll(l, a);
        }
        return l;
    }

    private String[] parsePid(String pid) {
        int n = pid.indexOf(45);
        if (n > 0) {
            String factoryPid = pid.substring(n + 1);
            pid = pid.substring(0, n);
            return new String[]{pid, factoryPid};
        }
        return new String[]{pid, null};
    }

    private Configuration getConfiguration(ConfigurationAdmin configAdmin, String zooKeeperPid, String pid, String factoryPid) throws Exception {
        String filter = "(fabric.zookeeper.pid=" + zooKeeperPid + ")";
        Configuration[] oldConfiguration = configAdmin.listConfigurations(filter);
        if (oldConfiguration != null && oldConfiguration.length > 0) {
            return oldConfiguration[0];
        }
        Configuration newConfiguration = factoryPid != null ? configAdmin.createFactoryConfiguration(pid, null) : configAdmin.getConfiguration(pid, null);
        return newConfiguration;
    }

    void bindConfigAdmin(ConfigurationAdmin service) {
        this.configAdmin.bind((Object)service);
    }

    void unbindConfigAdmin(ConfigurationAdmin service) {
        this.configAdmin.unbind((Object)service);
    }

    void bindContainerRegistration(ContainerRegistration service) {
        this.containerRegistration.bind((Object)service);
    }

    void unbindContainerRegistration(ContainerRegistration service) {
        this.containerRegistration.unbind((Object)service);
    }

    void bindFabricService(FabricService fabricService) {
        this.fabricService.bind((Object)fabricService);
    }

    void unbindFabricService(FabricService fabricService) {
        this.fabricService.unbind((Object)fabricService);
    }

    void bindUrlHandler(URLStreamHandlerService urlHandler) {
        this.urlHandler.bind((Object)urlHandler);
    }

    void unbindUrlHandler(URLStreamHandlerService urlHandler) {
        this.urlHandler.unbind((Object)urlHandler);
    }

    private static class NamedThreadFactory
    implements ThreadFactory {
        private static final AtomicInteger poolNumber = new AtomicInteger(1);
        private final ThreadGroup group;
        private final AtomicInteger threadNumber = new AtomicInteger(1);
        private final String namePrefix;

        NamedThreadFactory(String prefix) {
            SecurityManager s = System.getSecurityManager();
            this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
            this.namePrefix = prefix + "-" + poolNumber.getAndIncrement() + "-thread-";
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(this.group, r, this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
            if (t.isDaemon()) {
                t.setDaemon(false);
            }
            if (t.getPriority() != 5) {
                t.setPriority(5);
            }
            return t;
        }
    }
}

