/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.commands.support;

import io.fabric8.api.scr.AbstractComponent;
import io.fabric8.zookeeper.utils.ZooKeeperUtils;
import java.util.List;
import org.apache.curator.framework.CuratorFramework;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.karaf.shell.console.Completer;
import org.apache.karaf.shell.console.completer.StringsCompleter;

@Component(immediate=true)
@Service(value={ClusterCompleter.class, Completer.class})
public class ClusterCompleter
extends AbstractComponent
implements Completer {
    private static final String CLUSTER_PATH = "/fabric/registry/clusters";
    @Reference
    private CuratorFramework curator;

    public CuratorFramework getCurator() {
        return this.curator;
    }

    public void setCurator(CuratorFramework curator) {
        this.curator = curator;
    }

    @Activate
    void activate() {
        this.activateComponent();
    }

    @Deactivate
    void deactivate() {
        this.deactivateComponent();
    }

    public int complete(String buffer, int cursor, List candidates) {
        StringsCompleter delegate = new StringsCompleter();
        try {
            if (this.curator.getZookeeperClient().isConnected()) {
                delegate.getStrings().addAll(ZooKeeperUtils.getChildren((CuratorFramework)this.curator, (String)CLUSTER_PATH));
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        return delegate.complete(buffer, cursor, candidates);
    }

    protected void bindCurator(CuratorFramework curatorFramework) {
        this.curator = curatorFramework;
    }

    protected void unbindCurator(CuratorFramework curatorFramework) {
        if (this.curator == curatorFramework) {
            this.curator = null;
        }
    }
}

