/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.commands;

import com.google.common.base.Charsets;
import io.fabric8.api.Container;
import io.fabric8.api.FabricService;
import io.fabric8.api.Profile;
import io.fabric8.api.Version;
import io.fabric8.utils.FabricValidations;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.CompleterValues;
import org.apache.felix.gogo.commands.Option;
import org.apache.karaf.shell.console.AbstractAction;

@Command(name="profile-display", scope="fabric", description="Displays information about the specified version of the specified profile (where the version defaults to the current default version)")
public class ProfileDisplayAction
extends AbstractAction {
    @Option(name="--version", description="Select a specific profile version. Defaults to the current default version.")
    private String version;
    @Option(name="--overlay", aliases={"-o"}, description="Shows the effective profile settings, taking into account the settings inherited from parent profiles.")
    private Boolean overlay = false;
    @Option(name="--display-resources", aliases={"-r"}, description="Displays the content of additional profile resources.")
    private Boolean displayResources = false;
    @Argument(index=0, required=true, name="profile", description="The name of the profile.")
    @CompleterValues(index=0)
    private String name;
    private final FabricService fabricService;

    ProfileDisplayAction(FabricService fabricService) {
        this.fabricService = fabricService;
    }

    public FabricService getFabricService() {
        return this.fabricService;
    }

    protected Object doExecute() throws Exception {
        FabricValidations.validateProfileName(this.name);
        Version ver = this.version != null ? this.fabricService.getVersion(this.version) : this.fabricService.getDefaultVersion();
        for (Profile profile : ver.getProfiles()) {
            if (!this.name.equals(profile.getId())) continue;
            this.displayProfile(profile);
        }
        return null;
    }

    private String toString(Container[] containers) {
        StringBuffer rc = new StringBuffer();
        for (Container container : containers) {
            rc.append(container.getId());
            rc.append(" ");
        }
        return rc.toString().trim();
    }

    private static void printConfigList(String header, PrintStream out, List<String> list) {
        out.println(header);
        for (String str : list) {
            out.printf("\t%s\n", str);
        }
        out.println();
    }

    private void displayProfile(Profile p) {
        PrintStream output = this.session.getConsole();
        output.println("Profile id: " + p.getId());
        output.println("Version   : " + p.getVersion());
        output.println("Attributes: ");
        Map props = p.getAttributes();
        for (String key : props.keySet()) {
            output.println("\t" + key + ": " + (String)props.get(key));
        }
        output.printf("Containers: %s\n", this.toString(p.getAssociatedContainers()));
        Profile profile = this.overlay != false ? p.getOverlay() : p;
        Map configuration = profile.getConfigurations();
        Map resources = profile.getFileConfigurations();
        Map agentConfiguration = profile.getContainerConfiguration();
        ArrayList<String> agentProperties = new ArrayList<String>();
        ArrayList<String> systemProperties = new ArrayList<String>();
        ArrayList<String> configProperties = new ArrayList<String>();
        ArrayList otherResources = new ArrayList();
        for (Map.Entry entry : agentConfiguration.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (value.contains(",")) {
                value = "\t" + value.replace(",", ",\n\t\t");
            }
            if (key.startsWith("system.")) {
                systemProperties.add("  " + key.substring("system.".length()) + " = " + value);
                continue;
            }
            if (key.startsWith("config.")) {
                configProperties.add("  " + key.substring("config.".length()) + " = " + value);
                continue;
            }
            if (key.startsWith("feature.") || key.startsWith("repository") || key.startsWith("bundle.") || key.startsWith("fab.") || key.startsWith("override.") || key.startsWith("attribute.")) continue;
            agentProperties.add("  " + key + " = " + value);
        }
        if (configuration.containsKey("io.fabric8.agent")) {
            output.println("\nContainer settings");
            output.println("----------------------------");
            if (profile.getLibraries().size() > 0) {
                ProfileDisplayAction.printConfigList("Libraries : ", output, profile.getLibraries());
            }
            if (profile.getRepositories().size() > 0) {
                ProfileDisplayAction.printConfigList("Repositories : ", output, profile.getRepositories());
            }
            if (profile.getFeatures().size() > 0) {
                ProfileDisplayAction.printConfigList("Features : ", output, profile.getFeatures());
            }
            if (profile.getBundles().size() > 0) {
                ProfileDisplayAction.printConfigList("Bundles : ", output, profile.getBundles());
            }
            if (profile.getFabs().size() > 0) {
                ProfileDisplayAction.printConfigList("Fabs : ", output, profile.getFabs());
            }
            if (profile.getOverrides().size() > 0) {
                ProfileDisplayAction.printConfigList("Overrides : ", output, profile.getOverrides());
            }
            if (agentProperties.size() > 0) {
                ProfileDisplayAction.printConfigList("Agent Properties : ", output, agentProperties);
            }
            if (systemProperties.size() > 0) {
                ProfileDisplayAction.printConfigList("System Properties : ", output, systemProperties);
            }
            if (configProperties.size() > 0) {
                ProfileDisplayAction.printConfigList("Config Properties : ", output, configProperties);
            }
            configuration.remove("io.fabric8.agent");
        }
        output.println("\nConfiguration details");
        output.println("----------------------------");
        for (Map.Entry cfg : configuration.entrySet()) {
            output.println("PID: " + (String)cfg.getKey());
            for (Map.Entry values : ((Map)cfg.getValue()).entrySet()) {
                output.println("  " + (String)values.getKey() + " " + (String)values.getValue());
            }
            output.println("\n");
        }
        output.println("\nOther resources");
        output.println("----------------------------");
        for (Map.Entry resource : resources.entrySet()) {
            String name = (String)resource.getKey();
            if (name.endsWith(".properties")) continue;
            output.println("Resource: " + (String)resource.getKey());
            if (!this.displayResources.booleanValue()) continue;
            output.println(new String((byte[])resource.getValue(), Charsets.UTF_8));
            output.println("\n");
        }
    }
}

