/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.commands;

import io.fabric8.api.Profile;
import io.fabric8.api.Version;
import io.fabric8.boot.commands.support.FabricCommand;
import io.fabric8.commands.support.CommandUtils;
import java.io.PrintStream;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;

@Command(name="profile-list", scope="fabric", description="Lists all profiles that belong to the specified version (where the version defaults to the current default version)")
public class ProfileList
extends FabricCommand {
    @Option(name="--version", description="Specifies the version of the profiles to list. Defaults to the current default version.")
    private String version;
    @Option(name="--hidden", description="Display hidden profiles")
    private boolean hidden;

    protected Object doExecute() throws Exception {
        this.checkFabricAvailable();
        Version ver = this.version != null ? this.fabricService.getVersion(this.version) : this.fabricService.getDefaultVersion();
        Profile[] profiles = ver.getProfiles();
        profiles = CommandUtils.sortProfiles(profiles);
        this.printProfiles(profiles, System.out);
        return null;
    }

    protected void printProfiles(Profile[] profiles, PrintStream out) {
        out.println(String.format("%-40s %-14s %s", "[id]", "[# containers]", "[parents]"));
        for (Profile profile : profiles) {
            if (!this.hidden && profile.isHidden()) continue;
            int active = profile.getAssociatedContainers().length;
            out.println(String.format("%-40s %-14s %s", profile.getId(), active, ProfileList.toString((Profile[])profile.getParents())));
        }
    }
}

