/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.commands;

import io.fabric8.api.FabricService;
import io.fabric8.api.scr.ValidatingReference;
import io.fabric8.boot.commands.support.AbstractCommandComponent;
import io.fabric8.boot.commands.support.ContainerCompleter;
import io.fabric8.commands.ContainerResolverListAction;
import org.apache.felix.gogo.commands.Action;
import org.apache.felix.gogo.commands.basic.AbstractCommand;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.felix.service.command.Function;
import org.apache.karaf.shell.console.Completer;

@Component(immediate=true)
@Service(value={Function.class, AbstractCommand.class})
@Properties(value={@Property(name="osgi.command.scope", value={"fabric"}), @Property(name="osgi.command.function", value={"container-resolver-list"})})
public final class ContainerResolverList
extends AbstractCommandComponent {
    public static final String SCOPE_VALUE = "fabric";
    public static final String FUNCTION_VALUE = "container-resolver-list";
    public static final String DESCRIPTION = "List the resolver policy and the host data for each container in the fabric";
    @Reference(referenceInterface=FabricService.class)
    private final ValidatingReference<FabricService> fabricService = new ValidatingReference();
    @Reference(referenceInterface=ContainerCompleter.class, bind="bindContainerCompleter", unbind="unbindContainerCompleter")
    private ContainerCompleter containerCompleter;

    @Activate
    void activate() {
        this.activateComponent();
    }

    @Deactivate
    void deactivate() {
        this.deactivateComponent();
    }

    public Action createNewAction() {
        this.assertValid();
        return new ContainerResolverListAction((FabricService)this.fabricService.get());
    }

    void bindFabricService(FabricService fabricService) {
        this.fabricService.bind((Object)fabricService);
    }

    void unbindFabricService(FabricService fabricService) {
        this.fabricService.unbind((Object)fabricService);
    }

    void bindContainerCompleter(ContainerCompleter completer) {
        this.bindCompleter((Completer)completer);
    }

    void unbindContainerCompleter(ContainerCompleter completer) {
        this.unbindCompleter((Completer)completer);
    }
}

