/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.api.scr;

import io.fabric8.api.jcip.ThreadSafe;
import io.fabric8.api.permit.PermitKey;
import io.fabric8.api.permit.PermitManager;
import io.fabric8.api.scr.AbstractComponent;
import io.fabric8.api.scr.ValidatingReference;

@ThreadSafe
public abstract class AbstractProtectedComponent<T>
extends AbstractComponent {
    protected final ValidatingReference<PermitManager> permitManager = new ValidatingReference();

    protected void activateComponent(PermitKey<T> key, T instance) {
        super.activateComponent();
        this.permitManager.get().activate(key, instance);
    }

    protected void deactivateComponent(PermitKey<T> key) {
        this.permitManager.get().deactivate(key);
        super.deactivateComponent();
    }

    @Override
    public void activateComponent() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final void deactivateComponent() {
        throw new UnsupportedOperationException();
    }

    protected void bindPermitManager(PermitManager service) {
        this.permitManager.bind(service);
    }

    protected void unbindPermitManager(PermitManager service) {
        this.permitManager.unbind(service);
    }
}

