/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.api.jmx;

import io.fabric8.api.FabricService;
import io.fabric8.api.Profile;
import io.fabric8.api.ProfileBuilder;
import io.fabric8.api.ProfileService;
import io.fabric8.api.Profiles;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ProfileDTO {
    private String id;
    private String version;
    private String profileHash;
    private List<String> parents;
    private boolean overlay;
    private boolean abstractProfile;
    private boolean locked;
    private boolean hidden;
    private Map<String, String> attributes;
    private Set<String> configurations;
    private List<String> bundles;
    private List<String> fabs;
    private List<String> features;
    private List<String> repositories;
    private List<String> overrides;
    private String containersLink;
    private String overlayLink;
    private String requirementsLink;
    private String fileNameLinks;

    public ProfileDTO() {
    }

    public ProfileDTO(Profile profile) {
        this.id = profile.getId();
        this.version = profile.getVersion();
        this.profileHash = profile.getProfileHash();
        this.parents = Profiles.profileIds(profile.getParents());
        this.overlay = profile.isOverlay();
        this.abstractProfile = profile.isAbstract();
        this.locked = profile.isLocked();
        this.hidden = profile.isHidden();
        this.attributes = profile.getAttributes();
        this.bundles = profile.getBundles();
        this.features = profile.getFeatures();
        this.repositories = profile.getRepositories();
        this.fabs = profile.getFabs();
        this.overrides = profile.getOverrides();
        String versionId = profile.getVersion();
        String profileId = profile.getId();
        this.configurations = profile.getConfigurationFileNames();
    }

    public ProfileDTO(Profile profile, String containersLink, String overlayLink, String requirementsLink, String fileNameLinks) {
        this(profile);
        this.containersLink = containersLink;
        this.overlayLink = overlayLink;
        this.requirementsLink = requirementsLink;
        this.fileNameLinks = fileNameLinks;
    }

    public String toString() {
        return "ProfileDTO{id='" + this.id + '\'' + ", version='" + this.version + '\'' + '}';
    }

    public void populateBuilder(FabricService fabricService, ProfileService profileService, ProfileBuilder builder) {
        System.out.println("Parents are: " + this.parents);
        if (this.parents != null && this.parents.size() > 0 && this.version != null) {
            List<Profile> parentProfiles = Profiles.getProfiles(fabricService, this.parents, this.version);
            builder.setParents(parentProfiles);
            System.out.println("Found parents: " + parentProfiles);
        }
        builder.setOverlay(this.overlay);
        builder.setLocked(this.locked);
        if (this.attributes != null) {
            builder.setAttributes(this.attributes);
        }
        if (this.bundles != null) {
            builder.setBundles(this.bundles);
        }
        if (this.fabs != null) {
            builder.setBundles(this.fabs);
        }
        if (this.features != null) {
            builder.setBundles(this.features);
        }
        if (this.repositories != null) {
            builder.setBundles(this.repositories);
        }
        if (this.overrides != null) {
            builder.setBundles(this.overrides);
        }
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getProfileHash() {
        return this.profileHash;
    }

    public void setProfileHash(String profileHash) {
        this.profileHash = profileHash;
    }

    public List<String> getParents() {
        return this.parents;
    }

    public void setParents(List<String> parents) {
        this.parents = parents;
    }

    public boolean isOverlay() {
        return this.overlay;
    }

    public void setOverlay(boolean overlay) {
        this.overlay = overlay;
    }

    public boolean isAbstractProfile() {
        return this.abstractProfile;
    }

    public void setAbstractProfile(boolean abstractProfile) {
        this.abstractProfile = abstractProfile;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void setLocked(boolean locked) {
        this.locked = locked;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, String> attributes) {
        this.attributes = attributes;
    }

    public Set<String> getConfigurations() {
        return this.configurations;
    }

    public void setConfigurations(Set<String> configurations) {
        this.configurations = configurations;
    }

    public List<String> getBundles() {
        return this.bundles;
    }

    public void setBundles(List<String> bundles) {
        this.bundles = bundles;
    }

    public List<String> getFabs() {
        return this.fabs;
    }

    public void setFabs(List<String> fabs) {
        this.fabs = fabs;
    }

    public List<String> getFeatures() {
        return this.features;
    }

    public void setFeatures(List<String> features) {
        this.features = features;
    }

    public List<String> getRepositories() {
        return this.repositories;
    }

    public void setRepositories(List<String> repositories) {
        this.repositories = repositories;
    }

    public List<String> getOverrides() {
        return this.overrides;
    }

    public void setOverrides(List<String> overrides) {
        this.overrides = overrides;
    }

    public String getContainersLink() {
        return this.containersLink;
    }

    public void setContainersLink(String containersLink) {
        this.containersLink = containersLink;
    }

    public String getOverlayLink() {
        return this.overlayLink;
    }

    public void setOverlayLink(String overlayLink) {
        this.overlayLink = overlayLink;
    }

    public String getRequirementsLink() {
        return this.requirementsLink;
    }

    public void setRequirementsLink(String requirementsLink) {
        this.requirementsLink = requirementsLink;
    }

    public String getFileNameLinks() {
        return this.fileNameLinks;
    }

    public void setFileNameLinks(String fileNameLinks) {
        this.fileNameLinks = fileNameLinks;
    }
}

