/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.api;

import io.fabric8.api.Container;
import io.fabric8.api.FabricRequirements;
import io.fabric8.api.FabricService;
import io.fabric8.api.Profile;
import io.fabric8.api.ProfileRequirements;
import io.fabric8.api.ProfileStatus;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class FabricStatus {
    private FabricService service;
    private FabricRequirements requirements;
    private Map<String, ProfileStatus> profileStatusMap = new TreeMap<String, ProfileStatus>();

    public FabricStatus() {
    }

    public FabricStatus(FabricService service) {
        this.service = service;
        this.init();
    }

    public void init() {
        Container[] containers;
        this.requirements = this.service.getRequirements();
        List<ProfileRequirements> profileRequirements = this.requirements.getProfileRequirements();
        for (ProfileRequirements profileRequirement : profileRequirements) {
            String key = profileRequirement.getProfile();
            ProfileStatus status = this.profileStatusMap.get(key);
            if (status != null) continue;
            status = this.createStatus(key, profileRequirement);
            this.profileStatusMap.put(key, status);
        }
        for (Container container : containers = this.service.getContainers()) {
            Profile[] profiles;
            if (!container.isAliveAndOK()) continue;
            for (Profile profile : profiles = container.getProfiles()) {
                String key = profile.getId();
                ProfileStatus status = this.profileStatusMap.get(key);
                if (status == null) {
                    ProfileRequirements profileRequirement = new ProfileRequirements(key);
                    this.requirements.addOrUpdateProfileRequirements(profileRequirement);
                    status = this.createStatus(key, profileRequirement);
                    this.profileStatusMap.put(key, status);
                }
                status.incrementCount();
            }
        }
    }

    public Map<String, ProfileStatus> getProfileStatusMap() {
        return this.profileStatusMap;
    }

    public void setProfileStatusMap(Map<String, ProfileStatus> profileStatusMap) {
        this.profileStatusMap = profileStatusMap;
    }

    public FabricRequirements getRequirements() {
        return this.requirements;
    }

    public void setRequirements(FabricRequirements requirements) {
        this.requirements = requirements;
    }

    public FabricService getService() {
        return this.service;
    }

    public void setService(FabricService service) {
        this.service = service;
    }

    protected ProfileStatus createStatus(String profileId, ProfileRequirements profileRequirement) {
        return new ProfileStatus(profileId, profileRequirement);
    }

    public String toString() {
        return "FabricStatus[requirements=" + this.requirements.getProfileRequirements() + ", profileStatusMap=" + this.profileStatusMap + ']';
    }
}

