/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.api;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.api.DockerHostConfiguration;
import java.util.ArrayList;
import java.util.List;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class DockerConfiguration {
    private List<DockerHostConfiguration> hosts = new ArrayList<DockerHostConfiguration>();

    public DockerHostConfiguration getHost(String hostName) {
        if (this.hosts != null) {
            for (DockerHostConfiguration host : this.hosts) {
                if (!hostName.equals(host.getHostName())) continue;
                return host;
            }
        }
        return null;
    }

    public void addHost(DockerHostConfiguration configuration) {
        if (this.hosts == null) {
            this.hosts = new ArrayList<DockerHostConfiguration>();
        }
        this.hosts.add(configuration);
    }

    public DockerHostConfiguration host(String hostName) {
        DockerHostConfiguration answer = this.getHost(hostName);
        if (answer == null) {
            answer = new DockerHostConfiguration(hostName);
            this.addHost(answer);
        }
        return answer;
    }

    public List<DockerHostConfiguration> getHosts() {
        return this.hosts;
    }

    public void setHosts(List<DockerHostConfiguration> hosts) {
        this.hosts = hosts;
    }
}

