/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.api;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.List;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class AutoScaleProfileStatus
implements Comparable<AutoScaleProfileStatus> {
    private String profile;
    private String status;
    private String dependentProfile;
    private Integer currentInstances;
    private Integer minimumInstances;
    private String message;
    private List<String> containerIds;

    public AutoScaleProfileStatus() {
    }

    public AutoScaleProfileStatus(String profile) {
        this.profile = profile;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AutoScaleProfileStatus that = (AutoScaleProfileStatus)o;
        return this.profile.equals(that.profile);
    }

    @Override
    public int compareTo(AutoScaleProfileStatus o) {
        return this.profile.compareTo(o.profile);
    }

    public int hashCode() {
        return this.profile.hashCode();
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getProfile() {
        return this.profile;
    }

    public void setProfile(String profile) {
        this.profile = profile;
    }

    public String getDependentProfile() {
        return this.dependentProfile;
    }

    public void setDependentProfile(String dependentProfile) {
        this.dependentProfile = dependentProfile;
    }

    public Integer getCurrentInstances() {
        return this.currentInstances;
    }

    public void setCurrentInstances(Integer currentInstances) {
        this.currentInstances = currentInstances;
    }

    public Integer getMinimumInstances() {
        return this.minimumInstances;
    }

    public void setMinimumInstances(Integer minimumInstances) {
        this.minimumInstances = minimumInstances;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public List<String> getContainerIds() {
        return this.containerIds;
    }

    public void setContainerIds(List<String> containerIds) {
        this.containerIds = containerIds;
    }

    public void provisioned() {
        this.clear();
        this.status = "success";
    }

    public void provisioning() {
        this.clear();
        this.status = "provisioning";
    }

    public void creatingContainer() {
        this.clear();
        this.status = "creating a container";
    }

    public void destroyingContainer() {
        this.clear();
        this.status = "destroying a container";
    }

    public void stoppingContainers(List<String> containerIds) {
        this.clear();
        int size = containerIds.size();
        if (size > 1) {
            this.status = "stopping containers";
            this.message = "Stopping containers " + containerIds;
        } else if (size == 1) {
            this.status = "stopping container";
            this.message = "Stopping  container " + containerIds.get(0);
        } else {
            this.status = "completed stopping containers";
            this.message = "Containers stopped";
        }
    }

    protected void clear() {
        this.message = "";
        this.dependentProfile = null;
        this.currentInstances = null;
        this.currentInstances = null;
    }

    public void missingDependency(String dependentProfile, Integer currentInstances, Integer minimumInstances) {
        this.status = "waiting";
        this.dependentProfile = dependentProfile;
        this.currentInstances = currentInstances;
        this.minimumInstances = minimumInstances;
        this.message = "Waiting for profile " + dependentProfile + " to have " + minimumInstances + " instance(s) which currently has " + currentInstances;
    }

    public void noSuitableHost(String requirementsText) {
        this.status = "waiting";
        this.message = "Waiting for suitable host to become available for requirements: " + requirementsText;
    }
}

