/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.api;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.api.SshHostConfiguration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class SshConfiguration {
    private List<SshHostConfiguration> hosts = new ArrayList<SshHostConfiguration>();
    private String defaultPath;
    private Integer defaultPort;
    private String defaultUsername;
    private String defaultPassword;
    private List<String> fallbackRepositories;
    private String defaultPassPhrase;
    private String defaultPrivateKeyFile;

    public SshHostConfiguration getHost(String hostName) {
        if (this.hosts != null) {
            for (SshHostConfiguration host : this.hosts) {
                if (!hostName.equals(host.getHostName())) continue;
                return host;
            }
        }
        return null;
    }

    public void addHost(SshHostConfiguration configuration) {
        if (this.hosts == null) {
            this.hosts = new ArrayList<SshHostConfiguration>();
        }
        this.hosts.add(configuration);
    }

    public SshHostConfiguration host(String hostName) {
        SshHostConfiguration answer = this.getHost(hostName);
        if (answer == null) {
            answer = new SshHostConfiguration(hostName);
            this.addHost(answer);
        }
        return answer;
    }

    public SshConfiguration defaultPort(Integer defaultPort) {
        this.setDefaultPort(defaultPort);
        return this;
    }

    public SshConfiguration defaultPath(String defaultPath) {
        this.setDefaultPath(defaultPath);
        return this;
    }

    public SshConfiguration defaultUsername(String defaultUsername) {
        this.defaultUsername = defaultUsername;
        return this;
    }

    public SshConfiguration defaultPassword(String defaultPassword) {
        this.defaultPassword = defaultPassword;
        return this;
    }

    public SshConfiguration defaultPassPhrase(String defaultPassPhrase) {
        this.defaultPassPhrase = defaultPassPhrase;
        return this;
    }

    public SshConfiguration defaultPrivateKeyFile(String defaultPrivateKeyFile) {
        this.defaultPrivateKeyFile = defaultPrivateKeyFile;
        return this;
    }

    public SshConfiguration fallbackRepositories(List<String> fallbackRepositories) {
        this.fallbackRepositories = fallbackRepositories;
        return this;
    }

    public SshConfiguration fallbackRepositories(String ... fallbackRepositories) {
        return this.fallbackRepositories(Arrays.asList(fallbackRepositories));
    }

    public List<SshHostConfiguration> getHosts() {
        return this.hosts;
    }

    public void setHosts(List<SshHostConfiguration> hosts) {
        this.hosts = hosts;
    }

    public String getDefaultPath() {
        return this.defaultPath;
    }

    public void setDefaultPath(String defaultPath) {
        this.defaultPath = defaultPath;
    }

    public Integer getDefaultPort() {
        return this.defaultPort;
    }

    public void setDefaultPort(Integer defaultPort) {
        this.defaultPort = defaultPort;
    }

    public String getDefaultUsername() {
        return this.defaultUsername;
    }

    public void setDefaultUsername(String defaultUsername) {
        this.defaultUsername = defaultUsername;
    }

    public String getDefaultPassword() {
        return this.defaultPassword;
    }

    public void setDefaultPassword(String defaultPassword) {
        this.defaultPassword = defaultPassword;
    }

    public List<String> getFallbackRepositories() {
        return this.fallbackRepositories;
    }

    public void setFallbackRepositories(List<String> fallbackRepositories) {
        this.fallbackRepositories = fallbackRepositories;
    }

    public String getDefaultPassPhrase() {
        return this.defaultPassPhrase;
    }

    public void setDefaultPassPhrase(String defaultPassPhrase) {
        this.defaultPassPhrase = defaultPassPhrase;
    }

    public String getDefaultPrivateKeyFile() {
        return this.defaultPrivateKeyFile;
    }

    public void setDefaultPrivateKeyFile(String defaultPrivateKeyFile) {
        this.defaultPrivateKeyFile = defaultPrivateKeyFile;
    }
}

