/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.jaxb.dynamic;

import io.fabric8.jaxb.dynamic.CompileResults;
import io.fabric8.jaxb.dynamic.CompileResultsHandler;
import io.fabric8.jaxb.dynamic.DynamicCompiler;
import io.fabric8.jaxb.dynamic.DynamicXJC;
import java.util.Collection;
import org.apache.camel.util.ObjectHelper;

public class DefaultDynamicCompiler
implements DynamicCompiler {
    private String[] urls;
    private ClassLoader classLoader;

    public static CompileResults doCompile(ClassLoader classLoader, Collection<String> urls) {
        String[] array = urls.toArray(new String[urls.size()]);
        DefaultDynamicCompiler compiler = new DefaultDynamicCompiler(classLoader, array);
        return compiler.compile();
    }

    public DefaultDynamicCompiler() {
    }

    public DefaultDynamicCompiler(String ... urls) {
        this.urls = urls;
    }

    public DefaultDynamicCompiler(ClassLoader classLoader, String[] urls) {
        this.classLoader = classLoader;
        this.urls = urls;
    }

    @Override
    public void setHandler(CompileResultsHandler handler) {
        ObjectHelper.notNull((Object)handler, (String)"handler");
        CompileResults compileResults = this.compile();
        handler.onCompileResults(compileResults);
    }

    public CompileResults compile() {
        ObjectHelper.notNull((Object)this.urls, (String)"urls");
        DynamicXJC xjc = new DynamicXJC(this.getClassLoader());
        for (String url : this.urls) {
            xjc.addSchemaUrl(url);
        }
        CompileResults compileResults = xjc.compileSchemas();
        return compileResults;
    }

    public ClassLoader getClassLoader() {
        if (this.classLoader == null) {
            return this.getClass().getClassLoader();
        }
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public String[] getUrls() {
        return this.urls;
    }

    public void setUrls(String[] urls) {
        this.urls = urls;
    }
}

