/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.crd.generator.maven.plugin;

import java.util.HashSet;
import java.util.Set;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.project.MavenProject;

public enum ClasspathType {
    PROJECT_ONLY,
    WITH_RUNTIME_DEPENDENCIES,
    WITH_COMPILE_DEPENDENCIES,
    WITH_ALL_DEPENDENCIES,
    WITH_ALL_DEPENDENCIES_AND_TESTS;


    public Set<String> getClasspathElements(MavenProject project) {
        HashSet<String> classpathElements = new HashSet<String>();
        try {
            switch (this) {
                case PROJECT_ONLY: {
                    classpathElements.add(project.getBuild().getOutputDirectory());
                    break;
                }
                case WITH_COMPILE_DEPENDENCIES: {
                    classpathElements.addAll(project.getCompileClasspathElements());
                    break;
                }
                case WITH_RUNTIME_DEPENDENCIES: {
                    classpathElements.addAll(project.getRuntimeClasspathElements());
                    break;
                }
                case WITH_ALL_DEPENDENCIES: {
                    classpathElements.addAll(project.getRuntimeClasspathElements());
                    classpathElements.addAll(project.getCompileClasspathElements());
                    break;
                }
                case WITH_ALL_DEPENDENCIES_AND_TESTS: {
                    classpathElements.addAll(project.getRuntimeClasspathElements());
                    classpathElements.addAll(project.getCompileClasspathElements());
                    classpathElements.addAll(project.getTestClasspathElements());
                }
            }
        }
        catch (DependencyResolutionRequiredException e) {
            throw new IllegalStateException("Failed to resolve classpathType elements", e);
        }
        return classpathElements;
    }
}

