/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.crd.generator.cli;

import io.fabric8.crd.generator.cli.CustomResourceClassNotFoundException;
import io.fabric8.crd.generator.collector.CustomResourceClassLoaderException;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

class CRDGeneratorExecutionExceptionHandler
implements CommandLine.IExecutionExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(CRDGeneratorExecutionExceptionHandler.class);
    private final Supplier<String> debugTextSupplier;

    CRDGeneratorExecutionExceptionHandler(Supplier<String> debugTextSupplier) {
        this.debugTextSupplier = debugTextSupplier;
    }

    @Override
    public int handleExecutionException(Exception ex, CommandLine commandLine, CommandLine.ParseResult fullParseResult) {
        commandLine.getErr().println(ex.getMessage());
        if (ex instanceof CustomResourceClassLoaderException) {
            commandLine.getErr().println();
            commandLine.getErr().println("The classloader could not load the Custom Resource class.");
            commandLine.getErr().println("Check the list of classpath elements and add further JAR archives or directories containing required classes e.g. with `-cp my-dep.jar` or `-cp target/classes/`.");
            commandLine.getErr().print(this.debugTextSupplier.get());
            commandLine.getErr().flush();
            return 70;
        }
        if (ex instanceof CustomResourceClassNotFoundException) {
            commandLine.getErr().println();
            commandLine.getErr().println("Check JAR files and directories considered to be scanned as well as your filters. At least one Custom Resource class must be retained after filtering.");
            commandLine.getErr().print(this.debugTextSupplier.get());
            commandLine.getErr().flush();
            return 80;
        }
        if (log.isDebugEnabled()) {
            commandLine.getErr().println(this.debugTextSupplier.get());
        }
        log.trace(ex.getMessage(), ex);
        commandLine.getErr().flush();
        return 1;
    }
}

