/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.resource.v1beta1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.NodeSelector;
import io.fabric8.kubernetes.api.model.resource.v1beta1.AllocationResult;
import io.fabric8.kubernetes.api.model.resource.v1beta1.DeviceAllocationResult;
import io.fabric8.kubernetes.api.model.resource.v1beta1.DeviceAllocationResultBuilder;
import io.fabric8.kubernetes.api.model.resource.v1beta1.DeviceAllocationResultFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class AllocationResultFluent<A extends AllocationResultFluent<A>>
extends BaseFluent<A> {
    private DeviceAllocationResultBuilder devices;
    private NodeSelector nodeSelector;
    private Map<String, Object> additionalProperties;

    public AllocationResultFluent() {
    }

    public AllocationResultFluent(AllocationResult instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(AllocationResult instance) {
        AllocationResult allocationResult = instance = instance != null ? instance : new AllocationResult();
        if (instance != null) {
            this.withDevices(instance.getDevices());
            this.withNodeSelector(instance.getNodeSelector());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public DeviceAllocationResult buildDevices() {
        return this.devices != null ? this.devices.build() : null;
    }

    public A withDevices(DeviceAllocationResult devices) {
        this._visitables.remove("devices");
        if (devices != null) {
            this.devices = new DeviceAllocationResultBuilder(devices);
            this._visitables.get("devices").add(this.devices);
        } else {
            this.devices = null;
            this._visitables.get("devices").remove(this.devices);
        }
        return (A)this;
    }

    public boolean hasDevices() {
        return this.devices != null;
    }

    public DevicesNested<A> withNewDevices() {
        return new DevicesNested(null);
    }

    public DevicesNested<A> withNewDevicesLike(DeviceAllocationResult item) {
        return new DevicesNested(item);
    }

    public DevicesNested<A> editDevices() {
        return this.withNewDevicesLike(Optional.ofNullable(this.buildDevices()).orElse(null));
    }

    public DevicesNested<A> editOrNewDevices() {
        return this.withNewDevicesLike(Optional.ofNullable(this.buildDevices()).orElse(new DeviceAllocationResultBuilder().build()));
    }

    public DevicesNested<A> editOrNewDevicesLike(DeviceAllocationResult item) {
        return this.withNewDevicesLike(Optional.ofNullable(this.buildDevices()).orElse(item));
    }

    public NodeSelector getNodeSelector() {
        return this.nodeSelector;
    }

    public A withNodeSelector(NodeSelector nodeSelector) {
        this.nodeSelector = nodeSelector;
        return (A)this;
    }

    public boolean hasNodeSelector() {
        return this.nodeSelector != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AllocationResultFluent that = (AllocationResultFluent)o;
        if (!Objects.equals(this.devices, that.devices)) {
            return false;
        }
        if (!Objects.equals(this.nodeSelector, that.nodeSelector)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.devices, this.nodeSelector, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.devices != null) {
            sb.append("devices:");
            sb.append(this.devices + ",");
        }
        if (this.nodeSelector != null) {
            sb.append("nodeSelector:");
            sb.append(this.nodeSelector + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class DevicesNested<N>
    extends DeviceAllocationResultFluent<DevicesNested<N>>
    implements Nested<N> {
        DeviceAllocationResultBuilder builder;

        DevicesNested(DeviceAllocationResult item) {
            this.builder = new DeviceAllocationResultBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)AllocationResultFluent.this.withDevices(this.builder.build());
        }

        public N endDevices() {
            return this.and();
        }
    }
}

