/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.apiextensions.v1beta1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaProps;
import io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaPropsBuilder;
import io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaPropsFluent;
import io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaPropsOrStringArray;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class JSONSchemaPropsOrStringArrayFluent<A extends JSONSchemaPropsOrStringArrayFluent<A>>
extends BaseFluent<A> {
    private List<String> property = new ArrayList<String>();
    private JSONSchemaPropsBuilder schema;
    private Map<String, Object> additionalProperties;

    public JSONSchemaPropsOrStringArrayFluent() {
    }

    public JSONSchemaPropsOrStringArrayFluent(JSONSchemaPropsOrStringArray instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(JSONSchemaPropsOrStringArray instance) {
        JSONSchemaPropsOrStringArray jSONSchemaPropsOrStringArray = instance = instance != null ? instance : new JSONSchemaPropsOrStringArray();
        if (instance != null) {
            this.withProperty(instance.getProperty());
            this.withSchema(instance.getSchema());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToProperty(int index, String item) {
        if (this.property == null) {
            this.property = new ArrayList<String>();
        }
        this.property.add(index, item);
        return (A)this;
    }

    public A setToProperty(int index, String item) {
        if (this.property == null) {
            this.property = new ArrayList<String>();
        }
        this.property.set(index, item);
        return (A)this;
    }

    public A addToProperty(String ... items) {
        if (this.property == null) {
            this.property = new ArrayList<String>();
        }
        for (String item : items) {
            this.property.add(item);
        }
        return (A)this;
    }

    public A addAllToProperty(Collection<String> items) {
        if (this.property == null) {
            this.property = new ArrayList<String>();
        }
        for (String item : items) {
            this.property.add(item);
        }
        return (A)this;
    }

    public A removeFromProperty(String ... items) {
        if (this.property == null) {
            return (A)this;
        }
        for (String item : items) {
            this.property.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromProperty(Collection<String> items) {
        if (this.property == null) {
            return (A)this;
        }
        for (String item : items) {
            this.property.remove(item);
        }
        return (A)this;
    }

    public List<String> getProperty() {
        return this.property;
    }

    public String getProperty(int index) {
        return this.property.get(index);
    }

    public String getFirstProperty() {
        return this.property.get(0);
    }

    public String getLastProperty() {
        return this.property.get(this.property.size() - 1);
    }

    public String getMatchingProperty(Predicate<String> predicate) {
        for (String item : this.property) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingProperty(Predicate<String> predicate) {
        for (String item : this.property) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withProperty(List<String> property) {
        if (property != null) {
            this.property = new ArrayList<String>();
            for (String item : property) {
                this.addToProperty(item);
            }
        } else {
            this.property = null;
        }
        return (A)this;
    }

    public A withProperty(String ... property) {
        if (this.property != null) {
            this.property.clear();
            this._visitables.remove("property");
        }
        if (property != null) {
            for (String item : property) {
                this.addToProperty(item);
            }
        }
        return (A)this;
    }

    public boolean hasProperty() {
        return this.property != null && !this.property.isEmpty();
    }

    public JSONSchemaProps buildSchema() {
        return this.schema != null ? this.schema.build() : null;
    }

    public A withSchema(JSONSchemaProps schema) {
        this._visitables.remove("schema");
        if (schema != null) {
            this.schema = new JSONSchemaPropsBuilder(schema);
            this._visitables.get("schema").add(this.schema);
        } else {
            this.schema = null;
            this._visitables.get("schema").remove(this.schema);
        }
        return (A)this;
    }

    public boolean hasSchema() {
        return this.schema != null;
    }

    public SchemaNested<A> withNewSchema() {
        return new SchemaNested(null);
    }

    public SchemaNested<A> withNewSchemaLike(JSONSchemaProps item) {
        return new SchemaNested(item);
    }

    public SchemaNested<A> editSchema() {
        return this.withNewSchemaLike(Optional.ofNullable(this.buildSchema()).orElse(null));
    }

    public SchemaNested<A> editOrNewSchema() {
        return this.withNewSchemaLike(Optional.ofNullable(this.buildSchema()).orElse(new JSONSchemaPropsBuilder().build()));
    }

    public SchemaNested<A> editOrNewSchemaLike(JSONSchemaProps item) {
        return this.withNewSchemaLike(Optional.ofNullable(this.buildSchema()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        JSONSchemaPropsOrStringArrayFluent that = (JSONSchemaPropsOrStringArrayFluent)o;
        if (!Objects.equals(this.property, that.property)) {
            return false;
        }
        if (!Objects.equals(this.schema, that.schema)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.property, this.schema, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.property != null && !this.property.isEmpty()) {
            sb.append("property:");
            sb.append(this.property + ",");
        }
        if (this.schema != null) {
            sb.append("schema:");
            sb.append(this.schema + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class SchemaNested<N>
    extends JSONSchemaPropsFluent<SchemaNested<N>>
    implements Nested<N> {
        JSONSchemaPropsBuilder builder;

        SchemaNested(JSONSchemaProps item) {
            this.builder = new JSONSchemaPropsBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)JSONSchemaPropsOrStringArrayFluent.this.withSchema(this.builder.build());
        }

        public N endSchema() {
            return this.and();
        }
    }
}

