/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.internal;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.fabric8.kubernetes.internal.KubernetesDeserializer;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class KubernetesDeserializerForMap
extends JsonDeserializer<Map<String, KubernetesResource>> {
    private final KubernetesDeserializer kubernetesDeserializer = new KubernetesDeserializer();

    @Override
    public Map<String, KubernetesResource> deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        JsonNode node = (JsonNode)p.readValueAsTree();
        if (!node.isObject()) {
            throw new JsonMappingException(p, "Expected map but found " + node.getNodeType());
        }
        LinkedHashMap<String, KubernetesResource> ret = new LinkedHashMap<String, KubernetesResource>();
        Iterator<Map.Entry<String, JsonNode>> it = node.fields();
        while (it.hasNext()) {
            Map.Entry<String, JsonNode> entry = it.next();
            ret.put(entry.getKey(), this.kubernetesDeserializer.deserialize(p, entry.getValue()));
        }
        return ret;
    }
}

