/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.crd.generator.apt;

import io.fabric8.crd.generator.CRDGenerationInfo;
import io.fabric8.crd.generator.CRDGenerator;
import io.fabric8.crd.generator.CustomResourceInfo;
import io.fabric8.crd.generator.annotation.Annotations;
import io.fabric8.crd.generator.annotation.Labels;
import io.fabric8.crd.generator.utils.Types;
import io.fabric8.kubernetes.api.Pluralize;
import io.fabric8.kubernetes.model.Scope;
import io.fabric8.kubernetes.model.annotation.Group;
import io.fabric8.kubernetes.model.annotation.Kind;
import io.fabric8.kubernetes.model.annotation.Plural;
import io.fabric8.kubernetes.model.annotation.ShortNames;
import io.fabric8.kubernetes.model.annotation.Singular;
import io.fabric8.kubernetes.model.annotation.Version;
import io.sundr.adapter.api.AdapterContextAware;
import io.sundr.adapter.api.Adapters;
import io.sundr.adapter.apt.AptContext;
import io.sundr.model.TypeDef;
import io.sundr.model.repo.DefinitionRepository;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.element.Element;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.StandardLocation;

@SupportedAnnotationTypes(value={"io.fabric8.kubernetes.model.annotation.Version"})
public class CustomResourceAnnotationProcessor
extends AbstractProcessor {
    public static final String PROCESSOR_OPTION_PARALLEL = "io.fabric8.crd.generator.parallel";
    private final CRDGenerator generator = new CRDGenerator();

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (roundEnv.processingOver()) {
            Messager messager = this.processingEnv.getMessager();
            CRDGenerator cRDGenerator = this.generator.withOutput((CRDGenerator.CRDOutput)new FileObjectCRDOutput(this.processingEnv));
            Map<String, String> options = this.processingEnv.getOptions();
            this.enableParallelGeneration(messager, cRDGenerator, options);
            CRDGenerationInfo cRDGenerationInfo = cRDGenerator.detailedGenerate();
            cRDGenerationInfo.getCRDDetailsPerNameAndVersion().forEach((crdName, versionToInfo) -> {
                messager.printMessage(Diagnostic.Kind.NOTE, "Generating CRD " + crdName + ":\n");
                versionToInfo.forEach((version, info) -> messager.printMessage(Diagnostic.Kind.NOTE, "  - " + version + " -> " + info.getFilePath()));
            });
            return true;
        }
        AptContext.create((Elements)this.processingEnv.getElementUtils(), (Types)this.processingEnv.getTypeUtils(), (DefinitionRepository)DefinitionRepository.getRepository());
        for (TypeElement typeElement : annotations) {
            for (Element element : roundEnv.getElementsAnnotatedWith(typeElement)) {
                if (!(element instanceof TypeElement)) continue;
                try {
                    Class<?> generatedAnnotation = Class.forName("javax.annotation.processing.Generated");
                    if (element.getAnnotationsByType(generatedAnnotation).length > 0) {
                        continue;
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
                this.generator.customResources(new CustomResourceInfo[]{this.toCustomResourceInfo((TypeElement)element)});
            }
        }
        return false;
    }

    private void enableParallelGeneration(Messager messager, CRDGenerator crdGenerator, Map<String, String> options) {
        if (options.containsKey(PROCESSOR_OPTION_PARALLEL)) {
            String rawValue = options.get(PROCESSOR_OPTION_PARALLEL);
            boolean parallel = Boolean.parseBoolean(rawValue);
            messager.printMessage(Diagnostic.Kind.NOTE, String.format("Found option %s set to %s, parallel set to %b ", PROCESSOR_OPTION_PARALLEL, rawValue, parallel));
            crdGenerator.withParallelGenerationEnabled(parallel);
        }
    }

    private CustomResourceInfo toCustomResourceInfo(TypeElement customResource) {
        TypeDef definition = Adapters.adaptType((Object)customResource, (AdapterContextAware)AptContext.getContext());
        definition = io.fabric8.crd.generator.utils.Types.unshallow((TypeDef)definition);
        Name crClassName = customResource.getQualifiedName();
        Types.SpecAndStatus specAndStatus = io.fabric8.crd.generator.utils.Types.resolveSpecAndStatusTypes((TypeDef)definition);
        if (specAndStatus.isUnreliable()) {
            System.out.println("Cannot reliably determine status types for  " + crClassName + " because it isn't parameterized with only spec and status types. Status replicas detection will be deactivated.");
        }
        String group = customResource.getAnnotation(Group.class).value();
        String version = customResource.getAnnotation(Version.class).value();
        String kind = Optional.ofNullable(customResource.getAnnotation(Kind.class)).map(Kind::value).orElse(customResource.getSimpleName().toString());
        String singular = Optional.ofNullable(customResource.getAnnotation(Singular.class)).map(Singular::value).orElse(kind.toLowerCase(Locale.ROOT));
        String plural = Optional.ofNullable(customResource.getAnnotation(Plural.class)).map(Plural::value).map(s -> s.toLowerCase(Locale.ROOT)).orElse(Pluralize.toPlural((String)singular));
        String[] shortNames = Optional.ofNullable(customResource.getAnnotation(ShortNames.class)).map(ShortNames::value).orElse(new String[0]);
        String[] annotations = Optional.ofNullable(customResource.getAnnotation(Annotations.class)).map(Annotations::value).orElse(new String[0]);
        String[] labels = Optional.ofNullable(customResource.getAnnotation(Labels.class)).map(Labels::value).orElse(new String[0]);
        boolean storage = customResource.getAnnotation(Version.class).storage();
        boolean served = customResource.getAnnotation(Version.class).served();
        Scope scope = io.fabric8.crd.generator.utils.Types.isNamespaced((TypeDef)definition) ? Scope.NAMESPACED : Scope.CLUSTER;
        return new CustomResourceInfo(group, version, kind, singular, plural, shortNames, storage, served, scope, definition, crClassName.toString(), specAndStatus.getSpecClassName(), specAndStatus.getStatusClassName(), annotations, labels);
    }

    private static class FileObjectCRDOutput
    extends CRDGenerator.AbstractCRDOutput<FileObjectOutputStream> {
        private final ProcessingEnvironment processingEnv;

        public FileObjectCRDOutput(ProcessingEnvironment processingEnv) {
            this.processingEnv = processingEnv;
        }

        protected FileObjectOutputStream createStreamFor(String crdName) throws IOException {
            return new FileObjectOutputStream(this.processingEnv.getFiler().createResource(StandardLocation.CLASS_OUTPUT, "", "META-INF/fabric8/" + crdName + ".yml", new Element[0]));
        }

        public URI crdURI(String crdName) {
            return ((FileObjectOutputStream)this.getStreamFor(crdName)).toUri();
        }
    }

    private static class FileObjectOutputStream
    extends OutputStream {
        private final FileObject yml;
        private final OutputStream out;

        public FileObjectOutputStream(FileObject yml) throws IOException {
            this.yml = yml;
            this.out = yml.openOutputStream();
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.out.write(b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.out.write(b, off, len);
        }

        @Override
        public void flush() throws IOException {
            this.out.flush();
        }

        @Override
        public void close() throws IOException {
            this.out.close();
        }

        @Override
        public void write(int b) throws IOException {
            this.out.write(b);
        }

        public URI toUri() {
            return this.yml.toUri();
        }
    }
}

