/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.crd.generator.apt;

import io.fabric8.crd.generator.CRDGenerator;
import io.fabric8.crd.generator.CustomResourceInfo;
import io.fabric8.kubernetes.api.Pluralize;
import io.fabric8.kubernetes.api.model.Namespaced;
import io.fabric8.kubernetes.client.CustomResource;
import io.fabric8.kubernetes.model.Scope;
import io.fabric8.kubernetes.model.annotation.Group;
import io.fabric8.kubernetes.model.annotation.Kind;
import io.fabric8.kubernetes.model.annotation.Plural;
import io.fabric8.kubernetes.model.annotation.ShortNames;
import io.fabric8.kubernetes.model.annotation.Singular;
import io.fabric8.kubernetes.model.annotation.Version;
import io.sundr.builder.TypedVisitor;
import io.sundr.builder.Visitor;
import io.sundr.codegen.CodegenContext;
import io.sundr.codegen.Constants;
import io.sundr.codegen.functions.ClassTo;
import io.sundr.codegen.functions.ElementTo;
import io.sundr.codegen.model.ClassRef;
import io.sundr.codegen.model.ClassRefBuilder;
import io.sundr.codegen.model.TypeDef;
import io.sundr.codegen.model.TypeDefBuilder;
import io.sundr.codegen.model.TypeParamDef;
import io.sundr.codegen.model.TypeParamRef;
import io.sundr.codegen.model.TypeRef;
import io.sundr.codegen.utils.TypeUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.element.Element;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.FileObject;
import javax.tools.StandardLocation;

@SupportedAnnotationTypes(value={"io.fabric8.kubernetes.model.annotation.Version"})
public class CustomResourceAnnotationProcessor
extends AbstractProcessor {
    private static final TypeDef CUSTOM_RESOURCE_DEF = (TypeDef)ClassTo.TYPEDEF.apply(CustomResource.class);
    final CRDGenerator generator = new CRDGenerator();
    private static final String CUSTOM_RESOURCE_NAME = CustomResource.class.getCanonicalName();

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (roundEnv.processingOver()) {
            this.generator.withOutput((CRDGenerator.CRDOutput)new FileObjectCRDOutput()).generate();
            return true;
        }
        CodegenContext.create((Elements)this.processingEnv.getElementUtils(), (Types)this.processingEnv.getTypeUtils());
        for (TypeElement typeElement : annotations) {
            for (Element element : roundEnv.getElementsAnnotatedWith(typeElement)) {
                if (!(element instanceof TypeElement)) continue;
                this.generator.customResources(new CustomResourceInfo[]{this.toCustomResourceInfo((TypeElement)element)});
            }
        }
        return false;
    }

    public TypeDef projectDefinition(ClassRef ref) {
        List arguments = ref.getArguments();
        TypeDef definition = ref.getDefinition();
        if (arguments.isEmpty()) {
            return definition;
        }
        final HashMap<String, TypeRef> genericMap = new HashMap<String, TypeRef>();
        for (int i = 0; i < arguments.size(); ++i) {
            String name = ((TypeParamDef)definition.getParameters().get(i)).getName();
            TypeRef typeRef = (TypeRef)ref.getArguments().get(i);
            genericMap.put(name, typeRef);
        }
        definition.getParameters().stream().collect(Collectors.toMap(TypeParamDef::getName, TypeParamDef::getBounds));
        return ((TypeDefBuilder)new TypeDefBuilder(definition).accept(new Visitor[]{new TypedVisitor<ClassRefBuilder>(){

            public void visit(ClassRefBuilder c) {
                ArrayList<TypeRef> arguments = new ArrayList<TypeRef>();
                Iterator iterator = c.buildArguments().iterator();
                while (iterator.hasNext()) {
                    TypeParamRef typeParamRef;
                    TypeRef mapping;
                    TypeRef arg;
                    TypeRef mappedRef = arg = (TypeRef)iterator.next();
                    if (arg instanceof TypeParamRef && (mapping = (TypeRef)genericMap.get((typeParamRef = (TypeParamRef)arg).getName())) != null) {
                        mappedRef = mapping;
                    }
                    arguments.add(mappedRef);
                }
                c.withArguments(arguments);
            }
        }})).build();
    }

    private CustomResourceInfo toCustomResourceInfo(TypeElement customResource) {
        ClassRef customResourceRef;
        TypeDef definition = (TypeDef)ElementTo.TYPEDEF.apply(customResource);
        Name crClassName = customResource.getQualifiedName();
        TypeRef specType = null;
        String specClassName = null;
        String statusClassName = null;
        TypeRef statusType = null;
        boolean unreliable = true;
        Set superClasses = definition.getExtendsList().stream().flatMap(s -> Stream.concat(Stream.of(s), this.projectDefinition((ClassRef)s).getExtendsList().stream())).collect(Collectors.toSet());
        Optional<ClassRef> optionalCustomResourceRef = superClasses.stream().filter(s -> s.getFullyQualifiedName().equals(CUSTOM_RESOURCE_NAME)).findFirst();
        if (optionalCustomResourceRef.isPresent() && (customResourceRef = optionalCustomResourceRef.get()).getArguments().size() == 2) {
            unreliable = false;
            specType = (TypeRef)customResourceRef.getArguments().get(0);
            specClassName = specType instanceof ClassRef ? ((ClassRef)specType).getFullyQualifiedName() : null;
            statusType = (TypeRef)customResourceRef.getArguments().get(1);
            String string = statusClassName = statusType instanceof ClassRef ? ((ClassRef)statusType).getFullyQualifiedName() : null;
        }
        if (unreliable) {
            System.out.println("Cannot reliably determine status types for  " + crClassName + " because it isn't parameterized with only spec and status types. Status replicas detection will be deactivated.");
        }
        String group = customResource.getAnnotation(Group.class).value();
        String version = customResource.getAnnotation(Version.class).value();
        String kind = Optional.ofNullable(customResource.getAnnotation(Kind.class)).map(Kind::value).orElse(customResource.getSimpleName().toString());
        String singular = Optional.ofNullable(customResource.getAnnotation(Singular.class)).map(Singular::value).orElse(kind.toLowerCase(Locale.ROOT));
        String plural = Optional.ofNullable(customResource.getAnnotation(Plural.class)).map(Plural::value).map(s -> s.toLowerCase(Locale.ROOT)).orElse(Pluralize.toPlural((String)singular));
        String[] shortNames = Optional.ofNullable(customResource.getAnnotation(ShortNames.class)).map(ShortNames::value).orElse(new String[0]);
        boolean storage = customResource.getAnnotation(Version.class).storage();
        boolean served = customResource.getAnnotation(Version.class).served();
        Scope scope = TypeUtils.unrollHierarchy((TypeDef)definition).stream().flatMap(s -> Stream.concat(Stream.of(s), s.getImplementsList().stream().flatMap(i -> TypeUtils.unrollHierarchy((TypeDef)i.getDefinition()).stream()))).filter(d -> d.getFullyQualifiedName().equals(Namespaced.class.getName())).map(d -> Scope.NAMESPACED).findAny().orElse(Scope.CLUSTER);
        return new CustomResourceInfo(group, version, kind, singular, plural, shortNames, storage, served, scope, definition, crClassName.toString(), specClassName, statusClassName);
    }

    private static Optional<ClassRef> getCustomResourceRef(TypeDef typeDef) {
        return CustomResourceAnnotationProcessor.superClassStream(typeDef).filter(s -> s.getDefinition().getFullyQualifiedName().equals(CustomResource.class.getName())).findFirst();
    }

    private static Optional<ClassRef> getCustomResourceSpec(Optional<ClassRef> customResourceRef) {
        return CustomResourceAnnotationProcessor.getCustomResourceTypeParam(customResourceRef, 0);
    }

    private static Optional<ClassRef> getCustomResourceStatus(Optional<ClassRef> customResourceRef) {
        return CustomResourceAnnotationProcessor.getCustomResourceTypeParam(customResourceRef, 1);
    }

    private static Optional<ClassRef> getCustomResourceTypeParam(Optional<ClassRef> customResourceRef, int parameterIndex) {
        return customResourceRef.filter(c -> c.getArguments() != null && c.getArguments().size() == 2).map(c -> (TypeRef)c.getArguments().get(parameterIndex)).filter(t -> t instanceof ClassRef).map(t -> (ClassRef)t);
    }

    public static Stream<ClassRef> superClassStream(TypeDef typeDef) {
        if (Constants.OBJECT.equals((Object)typeDef)) {
            return Stream.empty();
        }
        return typeDef.getExtendsList().stream().flatMap(s -> CustomResourceAnnotationProcessor.superClassStream(s.getDefinition()));
    }

    private class FileObjectCRDOutput
    implements CRDGenerator.CRDOutput {
        private FileObject yml;
        private OutputStream out;

        private FileObjectCRDOutput() {
        }

        public OutputStream outputFor(String crdFileName) throws IOException {
            this.yml = CustomResourceAnnotationProcessor.this.processingEnv.getFiler().createResource(StandardLocation.CLASS_OUTPUT, "", "META-INF/fabric8/" + crdFileName, new Element[0]);
            this.out = this.yml.openOutputStream();
            return this.out;
        }

        public URI crdURI() {
            return this.yml.toUri();
        }

        public void close() throws IOException {
            this.out.close();
        }
    }
}

