/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.crd.generator.visitor;

import io.fabric8.crd.generator.utils.Types;
import io.sundr.builder.TypedVisitor;
import io.sundr.builder.Visitor;
import io.sundr.model.ClassRef;
import io.sundr.model.Property;
import io.sundr.model.TypeDef;
import io.sundr.model.TypeDefBuilder;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class AnnotatedMultiPropertyPathDetector
extends TypedVisitor<TypeDefBuilder> {
    protected static final String DOT = ".";
    protected static final String STATUS = ".status.";
    private final String prefix;
    private final String annotationName;
    private final List<Property> parents;
    private final Map<String, Property> properties;
    private final Deque<Runnable> toRun;

    public AnnotatedMultiPropertyPathDetector(String prefix, String annotationName) {
        this(prefix, annotationName, new ArrayList<Property>(), new HashMap<String, Property>(), new ArrayDeque<Runnable>());
    }

    public AnnotatedMultiPropertyPathDetector(String prefix, String annotationName, List<Property> parents, Map<String, Property> properties, Deque<Runnable> toRun) {
        this.prefix = prefix;
        this.annotationName = annotationName;
        this.parents = parents;
        this.properties = properties;
        this.toRun = toRun;
    }

    private boolean excludePropertyProcessing(Property p) {
        return p.getAnnotations().stream().anyMatch(ann -> ann.getClassRef().getFullyQualifiedName().equals("com.fasterxml.jackson.annotation.JsonIgnore"));
    }

    public void visit(TypeDefBuilder builder) {
        TypeDef type = builder.build();
        List props = type.getProperties();
        for (Property p2 : props) {
            if (this.parents.contains(p2)) continue;
            ArrayList<Property> newParents = new ArrayList<Property>(this.parents);
            boolean match = p2.getAnnotations().stream().anyMatch(a -> a.getClassRef().getName().equals(this.annotationName));
            if (!match) continue;
            newParents.add(p2);
            this.properties.put(newParents.stream().map(Property::getName).collect(Collectors.joining(DOT, this.prefix, "")), p2);
        }
        props.stream().filter(p -> p.getTypeRef() instanceof ClassRef).forEach(p -> {
            ClassRef classRef;
            TypeDef propertyType;
            if (!(this.parents.contains(p) || this.excludePropertyProcessing((Property)p) || (propertyType = Types.typeDefFrom(classRef = (ClassRef)p.getTypeRef())).isEnum() || classRef.getPackageName().startsWith("java."))) {
                ArrayList<Property> newParents = new ArrayList<Property>(this.parents);
                newParents.add((Property)p);
                this.toRun.add(() -> new TypeDefBuilder(propertyType).accept(new Visitor[]{new AnnotatedMultiPropertyPathDetector(this.prefix, this.annotationName, newParents, this.properties, this.toRun)}));
            }
        });
        if (this.parents.isEmpty()) {
            while (!this.toRun.isEmpty()) {
                this.toRun.pop().run();
            }
        }
    }

    public Set<String> getPaths() {
        return this.properties.keySet();
    }

    public Map<String, Property> getProperties() {
        return this.properties;
    }
}

