/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.crd.generator.v1beta1.decorator;

import io.fabric8.crd.generator.decorator.Decorator;
import io.fabric8.crd.generator.decorator.ResourceProvidingDecorator;
import io.fabric8.crd.generator.v1beta1.decorator.AddCustomResourceDefinitionVersionDecorator;
import io.fabric8.crd.generator.v1beta1.decorator.CustomResourceDefinitionDecorator;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionBuilder;
import io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionFluent;
import io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionSpecFluent;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;

public class AddCustomResourceDefinitionResourceDecorator
extends ResourceProvidingDecorator<KubernetesListBuilder> {
    private String name;
    private String apiGroup;
    private String kind;
    private String scope;
    private String[] shortNames;
    private String plural;
    private String singular;
    private String[] annotations;
    private String[] labels;

    public AddCustomResourceDefinitionResourceDecorator(String name, String apiGroup, String kind, String scope, String[] shortNames, String plural, String singular, String[] annotations, String[] labels) {
        this.name = name;
        this.apiGroup = apiGroup;
        this.kind = kind;
        this.scope = scope;
        this.shortNames = shortNames;
        this.plural = plural;
        this.singular = singular;
        this.annotations = annotations;
        this.labels = labels;
    }

    public void visit(KubernetesListBuilder list) {
        boolean exists = list.getItems().stream().anyMatch(i -> i.getKind().equals("CustomResourceDefinition") && i.getMetadata().getName().equals(this.name) && ApiVersionUtil.trimVersion((String)i.getApiVersion()).equals("v1beta1"));
        if (!exists) {
            list.addToItems(new HasMetadata[]{((CustomResourceDefinitionBuilder)((CustomResourceDefinitionFluent.SpecNested)((CustomResourceDefinitionSpecFluent.NamesNested)((CustomResourceDefinitionSpecFluent.NamesNested)((CustomResourceDefinitionSpecFluent.NamesNested)((CustomResourceDefinitionSpecFluent.NamesNested)((CustomResourceDefinitionFluent.SpecNested)((CustomResourceDefinitionFluent.SpecNested)((CustomResourceDefinitionBuilder)((CustomResourceDefinitionFluent.MetadataNested)((CustomResourceDefinitionFluent.MetadataNested)((CustomResourceDefinitionFluent.MetadataNested)new CustomResourceDefinitionBuilder().withNewMetadata().withName(this.name)).withAnnotations(this.toMap(this.annotations))).withLabels(this.toMap(this.labels))).endMetadata()).withNewSpec().withScope(this.scope)).withGroup(this.apiGroup)).withNewNames().withKind(this.kind)).withShortNames(this.shortNames)).withPlural(this.plural)).withSingular(this.singular)).endNames()).endSpec()).build()});
        }
    }

    @Override
    public Class<? extends Decorator>[] before() {
        return new Class[]{AddCustomResourceDefinitionVersionDecorator.class, CustomResourceDefinitionDecorator.class};
    }

    public String toString() {
        return this.getClass().getName() + " [apiGroup=" + this.apiGroup + ", kind=" + this.kind + ", name=" + this.name + ", plural=" + this.plural + ", scope=" + this.scope + "]";
    }
}

