/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.crd.generator.visitor;

import io.fabric8.crd.generator.utils.Types;
import io.sundr.builder.TypedVisitor;
import io.sundr.model.ClassRef;
import io.sundr.model.TypeDef;
import io.sundr.model.TypeDefBuilder;
import io.sundr.model.TypeRef;
import io.sundr.model.utils.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ClassDependenciesVisitor
extends TypedVisitor<TypeDefBuilder> {
    private static final Map<String, Set<String>> traversedClasses = new HashMap<String, Set<String>>();
    private static final Map<String, String> crdNameToCrClass = new HashMap<String, String>();
    private final Set<String> classesForCR;
    private final Set<String> processed = new HashSet<String>();

    public ClassDependenciesVisitor(String crClassName, String crdName) {
        crdNameToCrClass.put(crdName, crClassName);
        this.classesForCR = traversedClasses.computeIfAbsent(crClassName, k -> new HashSet());
    }

    public void visit(TypeDefBuilder builder) {
        TypeDef type = builder.build();
        String className = type.getFullyQualifiedName();
        if (this.ignore(className) || this.processed.contains(className)) {
            return;
        }
        type.getReferences().forEach(c -> {
            String fqn = c.getFullyQualifiedName();
            if (this.ignore(fqn)) {
                return;
            }
            if (fqn.startsWith("java.util") && (Collections.isCollection((TypeRef)c) || ((Boolean)Collections.IS_MAP.apply(c)).booleanValue())) {
                c.getArguments().forEach(this::processTypeRef);
            } else if (!this.ignore(fqn) && this.classesForCR.add(fqn)) {
                c.getArguments().forEach(this::processTypeRef);
            }
        });
        type.getExtendsList().forEach(this::processTypeRef);
        this.processed.add(className);
    }

    private boolean ignore(String className) {
        return className.startsWith("java.") && !className.startsWith("java.util.") || className.startsWith("com.fasterxml.jackson") || className.startsWith("jdk.");
    }

    private void processTypeRef(TypeRef t) {
        if (t instanceof ClassRef) {
            ClassRef classRef = (ClassRef)t;
            this.visit(new TypeDefBuilder(Types.typeDefFrom(classRef)));
        }
    }

    public static Map<String, Set<String>> getTraversedClasses() {
        return traversedClasses;
    }

    public static Set<String> getDependentClasses(String crClassName) {
        return traversedClasses.get(crClassName);
    }

    public static Set<String> getDependentClassesFromCRDName(String crdName) {
        return traversedClasses.get(crdNameToCrClass.get(crdName));
    }
}

