/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.crd.generator.visitor;

import io.fabric8.crd.generator.utils.Types;
import io.sundr.builder.TypedVisitor;
import io.sundr.builder.Visitor;
import io.sundr.model.ClassRef;
import io.sundr.model.Property;
import io.sundr.model.TypeDef;
import io.sundr.model.TypeDefBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;

public class AnnotatedPropertyPathDetector
extends TypedVisitor<TypeDefBuilder> {
    protected static final String DOT = ".";
    protected static final String STATUS = ".status.";
    private final String prefix;
    private final String annotationName;
    private final List<Property> parents;
    private final AtomicReference<Optional<String>> reference;

    public AnnotatedPropertyPathDetector(String prefix, String annotationName) {
        this(prefix, annotationName, new ArrayList<Property>());
    }

    public AnnotatedPropertyPathDetector(String prefix, String annotationName, List<Property> parents) {
        this(prefix, annotationName, parents, new AtomicReference<Optional<String>>(Optional.empty()));
    }

    public AnnotatedPropertyPathDetector(String prefix, String annotationName, List<Property> parents, AtomicReference<Optional<String>> reference) {
        this.prefix = prefix;
        this.annotationName = annotationName;
        this.parents = parents;
        this.reference = reference;
    }

    public void visit(TypeDefBuilder builder) {
        TypeDef type = builder.build();
        List properties = type.getProperties();
        for (Property p2 : properties) {
            if (this.parents.contains(p2)) continue;
            ArrayList<Property> newParents = new ArrayList<Property>(this.parents);
            boolean match = p2.getAnnotations().stream().anyMatch(a -> a.getClassRef().getName().equals(this.annotationName));
            if (!match) continue;
            newParents.add(p2);
            this.reference.set(Optional.of(newParents.stream().map(Property::getName).collect(Collectors.joining(DOT, this.prefix, ""))));
            return;
        }
        properties.stream().filter(p -> p.getTypeRef() instanceof ClassRef).forEach(p -> {
            ClassRef classRef;
            TypeDef propertyType;
            if (!this.parents.contains(p) && !(propertyType = Types.typeDefFrom(classRef = (ClassRef)p.getTypeRef())).isEnum()) {
                ArrayList<Property> newParents = new ArrayList<Property>(this.parents);
                newParents.add((Property)p);
                ((TypeDefBuilder)new TypeDefBuilder(propertyType).accept(new Visitor[]{new AnnotatedPropertyPathDetector(this.prefix, this.annotationName, newParents, this.reference)})).build();
            }
        });
    }

    public Optional<String> getPath() {
        return this.reference.get();
    }
}

