/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.crd.generator.v1.decorator;

import io.fabric8.crd.generator.decorator.Decorator;
import io.fabric8.crd.generator.utils.Generics;
import io.fabric8.crd.generator.utils.Metadata;
import io.fabric8.crd.generator.v1.decorator.AddCustomResourceDefinitionResourceDecorator;
import io.fabric8.crd.generator.v1.decorator.AddCustomResourceDefinitionVersionDecorator;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.TypedVisitor;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinitionVersionBuilder;
import io.fabric8.kubernetes.client.utils.Utils;
import java.util.Optional;

public abstract class CustomResourceDefinitionVersionDecorator<T>
extends Decorator<VisitableBuilder> {
    protected static final String ANY = null;
    private final String name;
    private final String version;
    private final CustomResourceDefinitionVersionVisitor versionSelector = new CustomResourceDefinitionVersionVisitor();
    private final VersionVisitor versionVisitor = new VersionVisitor();

    public CustomResourceDefinitionVersionDecorator(String name, String version) {
        this.name = name;
        this.version = version;
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public void visit(VisitableBuilder builder) {
        Optional<ObjectMeta> objectMeta = Metadata.getMetadata((Builder)builder);
        if (!objectMeta.isPresent()) {
            return;
        }
        if (Utils.isNullOrEmpty((String)this.name) || objectMeta.map(ObjectMeta::getName).filter(s -> s.equals(this.name)).isPresent()) {
            builder.accept(new Visitor[]{this.versionSelector});
        }
    }

    public abstract void andThenVisit(T var1);

    @Override
    public Class<? extends Decorator>[] after() {
        return new Class[]{AddCustomResourceDefinitionResourceDecorator.class, AddCustomResourceDefinitionVersionDecorator.class};
    }

    @Override
    public Class<? extends Decorator>[] before() {
        return new Class[0];
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CustomResourceDefinitionVersionDecorator other = (CustomResourceDefinitionVersionDecorator)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.version == null ? other.version != null : !this.version.equals(other.version));
    }

    private class VersionVisitor
    extends TypedVisitor<T> {
        private VersionVisitor() {
        }

        public void visit(T version) {
            CustomResourceDefinitionVersionDecorator.this.andThenVisit(version);
        }

        public Class<T> getType() {
            return Generics.getTypeArguments(CustomResourceDefinitionVersionDecorator.class, CustomResourceDefinitionVersionDecorator.this.getClass()).get(0);
        }
    }

    private class CustomResourceDefinitionVersionVisitor
    extends TypedVisitor<CustomResourceDefinitionVersionBuilder> {
        private CustomResourceDefinitionVersionVisitor() {
        }

        public void visit(CustomResourceDefinitionVersionBuilder builder) {
            if (Utils.isNullOrEmpty((String)CustomResourceDefinitionVersionDecorator.this.version) || builder.getName().equals(CustomResourceDefinitionVersionDecorator.this.version)) {
                builder.accept(new Visitor[]{CustomResourceDefinitionVersionDecorator.this.versionVisitor});
            }
        }
    }
}

