/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.crd.generator.utils;

import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Optional;
import java.util.function.Predicate;

public class Metadata {
    public static Optional<String> getKind(Builder builder) {
        try {
            Method method = builder.getClass().getMethod("getKind", new Class[0]);
            Object o = method.invoke((Object)builder, new Object[0]);
            if (o instanceof String) {
                return Optional.of((String)o);
            }
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            // empty catch block
        }
        return Optional.empty();
    }

    public static Optional<ObjectMeta> getMetadata(Builder builder) {
        try {
            Method method = builder.getClass().getMethod("buildMetadata", new Class[0]);
            Object o = method.invoke((Object)builder, new Object[0]);
            if (o instanceof ObjectMeta) {
                return Optional.of((ObjectMeta)o);
            }
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            // empty catch block
        }
        return Optional.empty();
    }

    public static boolean addToLabels(Builder builder, String key, String value) {
        try {
            Method editMethod = builder.getClass().getMethod("editOrNewMetadata", new Class[0]);
            Object o = editMethod.invoke((Object)builder, new Object[0]);
            if (o instanceof ObjectMetaFluent) {
                ObjectMetaFluent fluent = (ObjectMetaFluent)o;
                fluent.addToLabels(key, value);
                Method endMethod = fluent.getClass().getMethod("endMetadata", new Class[0]);
                endMethod.invoke((Object)fluent, new Object[0]);
                return true;
            }
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            // empty catch block
        }
        return false;
    }

    public static boolean removeFromLabels(Builder builder, String key) {
        try {
            Method editMethod = builder.getClass().getMethod("editOrNewMetadata", new Class[0]);
            Object o = editMethod.invoke((Object)builder, new Object[0]);
            if (o instanceof ObjectMetaFluent) {
                ObjectMetaFluent fluent = (ObjectMetaFluent)o;
                fluent.removeFromLabels(key);
                Method endMethod = fluent.getClass().getMethod("endMetadata", new Class[0]);
                endMethod.invoke((Object)fluent, new Object[0]);
                return true;
            }
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            // empty catch block
        }
        return false;
    }

    public static Predicate<VisitableBuilder<? extends HasMetadata, ?>> matching(HasMetadata candidate) {
        return Metadata.matching(candidate.getApiVersion(), candidate.getKind(), candidate.getMetadata().getName());
    }

    public static Predicate<VisitableBuilder<? extends HasMetadata, ?>> matching(String apiVersion, String kind, String name) {
        return builder -> {
            HasMetadata item = (HasMetadata)builder.build();
            ObjectMeta metadata = item.getMetadata();
            return apiVersion.equals(item.getApiVersion()) && kind != null && kind.equals(item.getKind()) && name != null && name.equals(metadata.getName());
        };
    }
}

