/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.crd.generator.v1.decorator;

import io.fabric8.crd.generator.decorator.Decorator;
import io.fabric8.crd.generator.v1.decorator.AddCustomResourceDefinitionResourceDecorator;
import io.fabric8.crd.generator.v1.decorator.AddCustomResourceDefinitionVersionDecorator;
import io.fabric8.crd.generator.v1.decorator.CustomResourceDefinitionDecorator;
import io.fabric8.crd.generator.v1.decorator.SetStorageVersionDecorator;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinitionSpecFluent;
import io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinitionVersion;
import io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinitionVersionBuilder;
import io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinitionVersionFluentImpl;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;

public class EnsureSingleStorageVersionDecorator
extends CustomResourceDefinitionDecorator<CustomResourceDefinitionSpecFluent<?>> {
    private final AtomicReference<String> storageVersion = new AtomicReference();

    public EnsureSingleStorageVersionDecorator(String name) {
        super(name);
    }

    @Override
    public void andThenVisit(CustomResourceDefinitionSpecFluent<?> spec, ObjectMeta resourceMeta) {
        Predicate<CustomResourceDefinitionVersionBuilder> hasStorageVersion = CustomResourceDefinitionVersionFluentImpl::isStorage;
        if (spec.hasVersions().booleanValue() && !spec.hasMatchingVersion(hasStorageVersion).booleanValue()) {
            ((CustomResourceDefinitionSpecFluent.VersionsNested)spec.editFirstVersion().withStorage(Boolean.valueOf(true))).endVersion();
        }
        for (CustomResourceDefinitionVersion version : spec.buildVersions()) {
            if (!version.getStorage().booleanValue()) continue;
            String existing = this.storageVersion.get();
            if (existing != null && !existing.equals(version.getName())) {
                throw new IllegalStateException(String.format("'%s' custom resource has versions %s and %s marked as storage. Only one version can be marked as storage per custom resource.", resourceMeta.getName(), version.getName(), existing));
            }
            this.storageVersion.set(version.getName());
        }
    }

    @Override
    public Class<? extends Decorator>[] after() {
        return new Class[]{AddCustomResourceDefinitionResourceDecorator.class, AddCustomResourceDefinitionVersionDecorator.class, SetStorageVersionDecorator.class};
    }
}

