/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.crd.generator;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import io.fabric8.crd.generator.utils.Types;
import io.fabric8.kubernetes.api.model.Duration;
import io.fabric8.kubernetes.api.model.IntOrString;
import io.fabric8.kubernetes.api.model.Quantity;
import io.sundr.Function;
import io.sundr.builder.internal.functions.TypeAs;
import io.sundr.codegen.functions.ClassTo;
import io.sundr.codegen.model.ClassRef;
import io.sundr.codegen.model.PrimitiveRefBuilder;
import io.sundr.codegen.model.Property;
import io.sundr.codegen.model.TypeDef;
import io.sundr.codegen.model.TypeRef;
import io.sundr.codegen.utils.TypeUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;

public abstract class AbstractJsonSchema<T, B> {
    protected static final TypeDef QUANTITY = (TypeDef)ClassTo.TYPEDEF.apply(Quantity.class);
    protected static final TypeDef DURATION = (TypeDef)ClassTo.TYPEDEF.apply(Duration.class);
    protected static final TypeDef INT_OR_STRING = (TypeDef)ClassTo.TYPEDEF.apply(IntOrString.class);
    protected static final TypeDef BOOLEAN = (TypeDef)ClassTo.TYPEDEF.apply(Boolean.class);
    protected static final TypeDef STRING = (TypeDef)ClassTo.TYPEDEF.apply(String.class);
    protected static final TypeDef INT = (TypeDef)ClassTo.TYPEDEF.apply(Integer.class);
    protected static final TypeDef LONG = (TypeDef)ClassTo.TYPEDEF.apply(Long.class);
    protected static final TypeDef DOUBLE = (TypeDef)ClassTo.TYPEDEF.apply(Double.class);
    protected static final TypeDef DATE = (TypeDef)ClassTo.TYPEDEF.apply(Date.class);
    protected static final TypeRef QUANTITY_REF = QUANTITY.toReference(new TypeRef[0]);
    protected static final TypeRef DURATION_REF = DURATION.toReference(new TypeRef[0]);
    protected static final TypeRef INT_OR_STRING_REF = INT_OR_STRING.toReference(new TypeRef[0]);
    protected static final TypeRef BOOLEAN_REF = BOOLEAN.toReference(new TypeRef[0]);
    protected static final TypeRef STRING_REF = STRING.toReference(new TypeRef[0]);
    protected static final TypeRef INT_REF = INT.toReference(new TypeRef[0]);
    protected static final TypeRef LONG_REF = LONG.toReference(new TypeRef[0]);
    protected static final TypeRef DOUBLE_REF = DOUBLE.toReference(new TypeRef[0]);
    protected static final TypeRef DATE_REF = DATE.toReference(new TypeRef[0]);
    private static final String INT_OR_STRING_MARKER = "int_or_string";
    private static final String STRING_MARKER = "string";
    private static final String NUMBER_MARKER = "number";
    private static final String BOOLEAN_MARKER = "boolean";
    protected static final TypeRef P_INT_REF = ((PrimitiveRefBuilder)new PrimitiveRefBuilder().withName("int")).build();
    protected static final TypeRef P_LONG_REF = ((PrimitiveRefBuilder)new PrimitiveRefBuilder().withName("long")).build();
    protected static final TypeRef P_DOUBLE_REF = ((PrimitiveRefBuilder)new PrimitiveRefBuilder().withName("double")).build();
    protected static final TypeRef P_BOOLEAN_REF = ((PrimitiveRefBuilder)new PrimitiveRefBuilder().withName("boolean")).build();
    protected static final Map<TypeRef, String> COMMON_MAPPINGS = new HashMap<TypeRef, String>();

    protected T internalFrom(TypeDef definition, String ... ignore) {
        B builder = this.newBuilder();
        LinkedHashSet<String> ignores = ignore.length > 0 ? new LinkedHashSet<String>(Arrays.asList(ignore)) : Collections.emptySet();
        ArrayList<String> required = new ArrayList<String>();
        for (Property property : Types.allProperties(definition)) {
            String name = property.getName();
            if (property.isStatic() || ignores.contains(name)) continue;
            if (property.getAnnotations().stream().anyMatch(a -> a.getClassRef().getFullyQualifiedName().equals("javax.validation.constraints.NotNull"))) {
                required.add(name);
            }
            this.addProperty(property, builder, this.internalFrom(property.getTypeRef()));
        }
        return this.build(builder, required);
    }

    public abstract B newBuilder();

    public abstract void addProperty(Property var1, B var2, T var3);

    public abstract T build(B var1, List<String> var2);

    public T internalFrom(TypeRef typeRef) {
        if (typeRef.getDimensions() > 0 || TypeUtils.isCollection((TypeRef)typeRef)) {
            return this.collectionProperty(this.internalFrom((TypeRef)TypeAs.combine((Function[])new Function[]{TypeAs.UNWRAP_ARRAY_OF, TypeAs.UNWRAP_COLLECTION_OF}).apply((Object)typeRef)));
        }
        if (TypeUtils.isOptional((TypeRef)typeRef)) {
            return this.internalFrom((TypeRef)TypeAs.UNWRAP_OPTIONAL_OF.apply((Object)typeRef));
        }
        String typeName = COMMON_MAPPINGS.get(typeRef);
        if (typeName != null) {
            if (INT_OR_STRING_MARKER.equals(typeName)) {
                return this.mappedProperty(typeRef);
            }
            return this.singleProperty(typeName);
        }
        if (typeRef instanceof ClassRef) {
            ClassRef classRef = (ClassRef)typeRef;
            TypeDef def = classRef.getDefinition();
            if (def.isEnum()) {
                JsonNode[] enumValues = (JsonNode[])def.getProperties().stream().map(Property::getName).filter(n -> !n.startsWith("$")).map(arg_0 -> ((JsonNodeFactory)JsonNodeFactory.instance).textNode(arg_0)).toArray(JsonNode[]::new);
                return this.enumProperty(enumValues);
            }
            return this.internalFrom(def, new String[0]);
        }
        return null;
    }

    protected abstract T mappedProperty(TypeRef var1);

    protected abstract T collectionProperty(T var1);

    protected abstract T singleProperty(String var1);

    protected abstract T enumProperty(JsonNode ... var1);

    static {
        COMMON_MAPPINGS.put(STRING_REF, STRING_MARKER);
        COMMON_MAPPINGS.put(DATE_REF, STRING_MARKER);
        COMMON_MAPPINGS.put(INT_REF, "integer");
        COMMON_MAPPINGS.put(P_INT_REF, "integer");
        COMMON_MAPPINGS.put(LONG_REF, NUMBER_MARKER);
        COMMON_MAPPINGS.put(P_LONG_REF, NUMBER_MARKER);
        COMMON_MAPPINGS.put(DOUBLE_REF, NUMBER_MARKER);
        COMMON_MAPPINGS.put(P_DOUBLE_REF, NUMBER_MARKER);
        COMMON_MAPPINGS.put(BOOLEAN_REF, BOOLEAN_MARKER);
        COMMON_MAPPINGS.put(P_BOOLEAN_REF, BOOLEAN_MARKER);
        COMMON_MAPPINGS.put(QUANTITY_REF, INT_OR_STRING_MARKER);
        COMMON_MAPPINGS.put(INT_OR_STRING_REF, INT_OR_STRING_MARKER);
        COMMON_MAPPINGS.put(DURATION_REF, STRING_MARKER);
    }
}

