/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.crdv2.generator.v1;

import io.fabric8.crdv2.generator.AbstractCustomResourceHandler;
import io.fabric8.crdv2.generator.CRDUtils;
import io.fabric8.crdv2.generator.CustomResourceInfo;
import io.fabric8.crdv2.generator.ResolvingContext;
import io.fabric8.crdv2.generator.v1.JsonSchema;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinition;
import io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinitionBuilder;
import io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinitionFluent;
import io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinitionSpecFluent;
import io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinitionVersion;
import io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinitionVersionBuilder;
import io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinitionVersionFluent;
import io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceSubresourcesFluent;
import io.fabric8.kubernetes.api.model.apiextensions.v1.JSONSchemaProps;
import io.fabric8.kubernetes.client.utils.KubernetesVersionPriority;
import io.fabric8.kubernetes.client.utils.Utils;
import io.fabric8.kubernetes.model.annotation.LabelSelector;
import io.fabric8.kubernetes.model.annotation.SpecReplicas;
import io.fabric8.kubernetes.model.annotation.StatusReplicas;
import java.util.AbstractMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class CustomResourceHandler
extends AbstractCustomResourceHandler {
    private Queue<Map.Entry<CustomResourceDefinition, Set<String>>> crds = new ConcurrentLinkedQueue<Map.Entry<CustomResourceDefinition, Set<String>>>();
    public static final String VERSION = "v1";

    @Override
    public void handle(CustomResourceInfo config, ResolvingContext resolvingContext) {
        String name = config.crdName();
        String version = config.version();
        JsonSchema resolver = new JsonSchema(resolvingContext, config.definition());
        JSONSchemaProps schema = (JSONSchemaProps)resolver.getSchema();
        final CustomResourceDefinitionVersionBuilder builder = (CustomResourceDefinitionVersionBuilder)((CustomResourceDefinitionVersionFluent.SchemaNested)((CustomResourceDefinitionVersionBuilder)((CustomResourceDefinitionVersionBuilder)((CustomResourceDefinitionVersionBuilder)((CustomResourceDefinitionVersionBuilder)((CustomResourceDefinitionVersionBuilder)new CustomResourceDefinitionVersionBuilder().withName(version)).withStorage(Boolean.valueOf(config.storage()))).withServed(Boolean.valueOf(config.served()))).withDeprecated(config.deprecated() ? Boolean.valueOf(true) : null)).withDeprecationWarning(config.deprecationWarning())).withNewSchema().withOpenAPIV3Schema(schema)).endSchema();
        this.handlePrinterColumns(resolver, new AbstractCustomResourceHandler.PrinterColumnHandler(){

            @Override
            public void addPrinterColumn(String path, String column, String format, int priority, String type, String description) {
                ((CustomResourceDefinitionVersionFluent.AdditionalPrinterColumnsNested)((CustomResourceDefinitionVersionFluent.AdditionalPrinterColumnsNested)((CustomResourceDefinitionVersionFluent.AdditionalPrinterColumnsNested)((CustomResourceDefinitionVersionFluent.AdditionalPrinterColumnsNested)((CustomResourceDefinitionVersionFluent.AdditionalPrinterColumnsNested)((CustomResourceDefinitionVersionFluent.AdditionalPrinterColumnsNested)builder.addNewAdditionalPrinterColumn().withType(type)).withName(column)).withJsonPath(path)).withFormat(Utils.isNotNullOrEmpty((String)format) ? format : null)).withDescription(Utils.isNotNullOrEmpty((String)description) ? description : null)).withPriority(Integer.valueOf(priority))).endAdditionalPrinterColumn();
            }
        });
        resolver.getSinglePath(SpecReplicas.class).ifPresent(path -> ((CustomResourceDefinitionVersionFluent.SubresourcesNested)((CustomResourceSubresourcesFluent.ScaleNested)builder.editOrNewSubresources().editOrNewScale().withSpecReplicasPath(path)).endScale()).endSubresources());
        resolver.getSinglePath(StatusReplicas.class).ifPresent(path -> ((CustomResourceDefinitionVersionFluent.SubresourcesNested)((CustomResourceSubresourcesFluent.ScaleNested)builder.editOrNewSubresources().editOrNewScale().withStatusReplicasPath(path)).endScale()).endSubresources());
        resolver.getSinglePath(LabelSelector.class).ifPresent(path -> ((CustomResourceDefinitionVersionFluent.SubresourcesNested)((CustomResourceSubresourcesFluent.ScaleNested)builder.editOrNewSubresources().editOrNewScale().withLabelSelectorPath(path)).endScale()).endSubresources());
        if (config.statusClassName().isPresent()) {
            ((CustomResourceDefinitionVersionFluent.SubresourcesNested)builder.editOrNewSubresources().withNewStatus().endStatus()).endSubresources();
        }
        CustomResourceDefinition crd = ((CustomResourceDefinitionBuilder)((CustomResourceDefinitionFluent.SpecNested)((CustomResourceDefinitionFluent.SpecNested)((CustomResourceDefinitionSpecFluent.NamesNested)((CustomResourceDefinitionSpecFluent.NamesNested)((CustomResourceDefinitionSpecFluent.NamesNested)((CustomResourceDefinitionSpecFluent.NamesNested)((CustomResourceDefinitionFluent.SpecNested)((CustomResourceDefinitionFluent.SpecNested)((CustomResourceDefinitionBuilder)((CustomResourceDefinitionFluent.MetadataNested)((CustomResourceDefinitionFluent.MetadataNested)((CustomResourceDefinitionFluent.MetadataNested)new CustomResourceDefinitionBuilder().withNewMetadata().withName(name)).withAnnotations(CRDUtils.toMap(config.annotations()))).withLabels(CRDUtils.toMap(config.labels()))).endMetadata()).withNewSpec().withScope(config.scope().value())).withGroup(config.group())).withNewNames().withKind(config.kind())).withShortNames(config.shortNames())).withPlural(config.plural())).withSingular(config.singular())).endNames()).addToVersions(new CustomResourceDefinitionVersion[]{builder.build()})).endSpec()).build();
        this.crds.add(new AbstractMap.SimpleEntry<CustomResourceDefinition, Set<String>>(crd, resolver.getDependentClasses()));
    }

    @Override
    public Stream<Map.Entry<? extends HasMetadata, Set<String>>> finish() {
        return this.crds.stream().collect(Collectors.groupingBy(crd -> ((CustomResourceDefinition)crd.getKey()).getMetadata().getName())).values().stream().map(this::combine);
    }

    private Map.Entry<CustomResourceDefinition, Set<String>> combine(List<Map.Entry<CustomResourceDefinition, Set<String>>> definitions) {
        Map.Entry<CustomResourceDefinition, Set<String>> primary = definitions.get(0);
        if (definitions.size() == 1) {
            return primary;
        }
        List versions = definitions.stream().flatMap(crd -> ((CustomResourceDefinition)crd.getKey()).getSpec().getVersions().stream()).collect(Collectors.toList());
        Set allDependentClasses = definitions.stream().flatMap(crd -> ((Set)crd.getValue()).stream()).collect(Collectors.toSet());
        List storageVersions = versions.stream().filter(v -> Optional.ofNullable(v.getStorage()).orElse(true)).map(CustomResourceDefinitionVersion::getName).collect(Collectors.toList());
        if (storageVersions.size() > 1) {
            throw new IllegalStateException(String.format("'%s' custom resource has versions %s marked as storage. Only one version can be marked as storage per custom resource.", primary.getKey().getMetadata().getName(), storageVersions));
        }
        versions = KubernetesVersionPriority.sortByPriority(versions, CustomResourceDefinitionVersion::getName);
        return new AbstractMap.SimpleEntry<CustomResourceDefinition, Set<String>>(((CustomResourceDefinitionBuilder)((CustomResourceDefinitionFluent.SpecNested)new CustomResourceDefinitionBuilder(primary.getKey()).editSpec().withVersions(versions)).endSpec()).build(), allDependentClasses);
    }
}

