/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.crdv2.generator;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.module.jsonSchema.JsonSchema;
import com.fasterxml.jackson.module.jsonSchema.types.ArraySchema;
import com.fasterxml.jackson.module.jsonSchema.types.ObjectSchema;
import com.fasterxml.jackson.module.jsonSchema.types.ReferenceSchema;
import com.fasterxml.jackson.module.jsonSchema.types.StringSchema;
import com.fasterxml.jackson.module.jsonSchema.types.ValueTypeSchema;
import io.fabric8.crd.generator.annotation.PreserveUnknownFields;
import io.fabric8.crd.generator.annotation.PrinterColumn;
import io.fabric8.crd.generator.annotation.SchemaFrom;
import io.fabric8.crd.generator.annotation.SchemaSwap;
import io.fabric8.crdv2.generator.InternalSchemaSwaps;
import io.fabric8.crdv2.generator.KubernetesJSONSchemaProps;
import io.fabric8.crdv2.generator.KubernetesValidationRule;
import io.fabric8.crdv2.generator.ResolvingContext;
import io.fabric8.generator.annotation.Default;
import io.fabric8.generator.annotation.Max;
import io.fabric8.generator.annotation.Min;
import io.fabric8.generator.annotation.Nullable;
import io.fabric8.generator.annotation.Pattern;
import io.fabric8.generator.annotation.Required;
import io.fabric8.generator.annotation.ValidationRule;
import io.fabric8.generator.annotation.ValidationRules;
import io.fabric8.kubernetes.api.model.GenericKubernetesResource;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.IntOrString;
import io.fabric8.kubernetes.api.model.Quantity;
import io.fabric8.kubernetes.api.model.runtime.RawExtension;
import io.fabric8.kubernetes.client.utils.Utils;
import io.fabric8.kubernetes.model.annotation.LabelSelector;
import io.fabric8.kubernetes.model.annotation.SpecReplicas;
import io.fabric8.kubernetes.model.annotation.StatusReplicas;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJsonSchema<T extends KubernetesJSONSchemaProps, V extends KubernetesValidationRule> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractJsonSchema.class);
    private ResolvingContext resolvingContext;
    private T root;
    private Set<String> dependentClasses = new HashSet<String>();
    private Map<Class<? extends Annotation>, LinkedHashMap<String, AnnotationMetadata>> pathMetadata = new HashMap<Class<? extends Annotation>, LinkedHashMap<String, AnnotationMetadata>>();

    public AbstractJsonSchema(ResolvingContext resolvingContext, Class<?> def) {
        this.resolvingContext = resolvingContext;
        Stream.of(SpecReplicas.class, StatusReplicas.class, LabelSelector.class, PrinterColumn.class).forEach(clazz -> this.pathMetadata.put((Class<? extends Annotation>)clazz, new LinkedHashMap()));
        this.root = this.resolveRoot(def);
    }

    public T getSchema() {
        return this.root;
    }

    public Set<String> getDependentClasses() {
        return this.dependentClasses;
    }

    public Optional<String> getSinglePath(Class<? extends Annotation> clazz) {
        return Optional.ofNullable(this.pathMetadata.get(clazz)).flatMap(m -> m.keySet().stream().findFirst());
    }

    public Map<String, AnnotationMetadata> getAllPaths(Class<PrinterColumn> clazz) {
        return Optional.ofNullable(this.pathMetadata.get(clazz)).orElse(new LinkedHashMap());
    }

    private T resolveRoot(Class<?> definition) {
        InternalSchemaSwaps schemaSwaps = new InternalSchemaSwaps();
        JsonSchema schema = this.resolvingContext.toJsonSchema(definition);
        if (schema instanceof ResolvingContext.GeneratorObjectSchema) {
            return this.resolveObject(new LinkedHashMap<String, String>(), schemaSwaps, schema, "kind", "apiVersion", "metadata");
        }
        return this.resolveProperty(new LinkedHashMap<String, String>(), schemaSwaps, null, this.resolvingContext.objectMapper.getSerializationConfig().constructType(definition), schema);
    }

    private static <A extends Annotation> void consumeRepeatingAnnotation(Class<?> beanClass, Class<A> annotation, Consumer<A> consumer) {
        while (beanClass != null && beanClass != Object.class) {
            Stream.of(beanClass.getAnnotationsByType(annotation)).forEach(consumer);
            beanClass = beanClass.getSuperclass();
        }
    }

    void collectValidationRules(BeanProperty beanProperty, List<V> validationRules) {
        if (beanProperty.getMember() instanceof AnnotatedMethod) {
            Method m = ((AnnotatedMethod)beanProperty.getMember()).getMember();
            String name = m.getName();
            if (name.startsWith("get") || name.startsWith("set")) {
                name = name.substring(3);
            } else if (name.startsWith("is")) {
                name = name.substring(2);
            }
            if (name.length() > 0) {
                name = Character.toLowerCase(name.charAt(0)) + name.substring(1);
            }
            try {
                Field f = beanProperty.getMember().getDeclaringClass().getDeclaredField(name);
                Optional.ofNullable(f.getAnnotation(ValidationRule.class)).map(this::from).ifPresent(validationRules::add);
                Optional.ofNullable(f.getAnnotation(ValidationRules.class)).ifPresent(ann -> Stream.of(ann.value()).map(this::from).forEach(validationRules::add));
            }
            catch (NoSuchFieldException | SecurityException exception) {
            }
            Stream.of(m.getAnnotationsByType(ValidationRule.class)).map(this::from).forEach(validationRules::add);
            return;
        }
        Optional.ofNullable(beanProperty.getAnnotation(ValidationRule.class)).map(this::from).ifPresent(validationRules::add);
        Optional.ofNullable(beanProperty.getAnnotation(ValidationRules.class)).ifPresent(ann -> Stream.of(ann.value()).map(this::from).forEach(validationRules::add));
    }

    private T resolveObject(LinkedHashMap<String, String> visited, InternalSchemaSwaps schemaSwaps, JsonSchema jacksonSchema, String ... ignore) {
        LinkedHashSet<String> ignores = ignore.length > 0 ? new LinkedHashSet<String>(Arrays.asList(ignore)) : Collections.emptySet();
        T objectSchema = this.singleProperty("object");
        InternalSchemaSwaps swaps = schemaSwaps = schemaSwaps.branchAnnotations();
        ResolvingContext.GeneratorObjectSchema gos = (ResolvingContext.GeneratorObjectSchema)jacksonSchema.asObjectSchema();
        BeanDescription bd = this.resolvingContext.objectMapper.getSerializationConfig().introspect(gos.javaType);
        boolean preserveUnknownFields = false;
        if (this.resolvingContext.implicitPreserveUnknownFields) {
            preserveUnknownFields = bd.findAnyGetter() != null || bd.findAnySetterAccessor() != null;
        }
        Class rawClass = gos.javaType.getRawClass();
        this.collectDependentClasses(rawClass);
        AbstractJsonSchema.consumeRepeatingAnnotation(rawClass, SchemaSwap.class, ss -> swaps.registerSwap(rawClass, ss.originalType(), ss.fieldName(), ss.targetType(), ss.depth()));
        ArrayList<String> required = new ArrayList<String>();
        for (Map.Entry property : new TreeMap(gos.getProperties()).entrySet()) {
            String name = (String)property.getKey();
            if (ignores.contains(name)) continue;
            schemaSwaps = schemaSwaps.branchDepths();
            InternalSchemaSwaps.SwapResult swapResult = schemaSwaps.lookupAndMark(rawClass, name);
            LinkedHashMap<String, String> savedVisited = visited;
            if (swapResult.onGoing) {
                visited = new LinkedHashMap();
            }
            BeanProperty beanProperty = gos.beanProperties.get(property.getKey());
            Utils.checkNotNull((Object)beanProperty, (String)"CRD generation works only with bean properties");
            JsonSchema propertySchema = (JsonSchema)property.getValue();
            PropertyMetadata propertyMetadata = new PropertyMetadata(propertySchema, beanProperty);
            if (propertyMetadata.required) {
                required.add(name);
            }
            JavaType type = beanProperty.getType();
            if (swapResult.classRef != null) {
                propertyMetadata.schemaFrom = swapResult.classRef;
            }
            if (propertyMetadata.schemaFrom != null) {
                if (propertyMetadata.schemaFrom == Void.TYPE) continue;
                propertySchema = this.resolvingContext.toJsonSchema(propertyMetadata.schemaFrom);
                type = this.resolvingContext.objectMapper.getSerializationConfig().constructType(propertyMetadata.schemaFrom);
            }
            Object schema = this.resolveProperty(visited, schemaSwaps, name, type, propertySchema);
            propertyMetadata.updateSchema(schema);
            if (!swapResult.onGoing) {
                for (Map.Entry<Class<? extends Annotation>, LinkedHashMap<String, AnnotationMetadata>> entry : this.pathMetadata.entrySet()) {
                    Optional.ofNullable(beanProperty.getAnnotation(entry.getKey())).ifPresent(ann -> ((LinkedHashMap)entry.getValue()).put(AbstractJsonSchema.toFQN(savedVisited, name), new AnnotationMetadata((Annotation)ann, (KubernetesJSONSchemaProps)schema)));
                }
            }
            visited = savedVisited;
            this.addProperty(name, objectSchema, schema);
        }
        swaps.throwIfUnmatchedSwaps();
        objectSchema.setRequired(required);
        if (preserveUnknownFields) {
            objectSchema.setXKubernetesPreserveUnknownFields(true);
        }
        ArrayList validationRules = new ArrayList();
        AbstractJsonSchema.consumeRepeatingAnnotation(rawClass, ValidationRule.class, v -> validationRules.add(this.from((ValidationRule)v)));
        this.addToValidationRules(objectSchema, validationRules);
        return objectSchema;
    }

    private void collectDependentClasses(Class<?> rawClass) {
        if (rawClass != null && !rawClass.getName().startsWith("java.") && this.dependentClasses.add(rawClass.getName())) {
            Stream.of(rawClass.getInterfaces()).forEach(this::collectDependentClasses);
            this.collectDependentClasses(rawClass.getSuperclass());
        }
    }

    static String toFQN(LinkedHashMap<String, String> visited, String name) {
        if (visited.isEmpty()) {
            return "." + name;
        }
        return visited.values().stream().collect(Collectors.joining(".", ".", ".")) + name;
    }

    private T resolveProperty(LinkedHashMap<String, String> visited, InternalSchemaSwaps schemaSwaps, String name, JavaType type, JsonSchema jacksonSchema) {
        if (jacksonSchema.isArraySchema()) {
            ArraySchema.Items items = jacksonSchema.asArraySchema().getItems();
            if (items.isArrayItems()) {
                throw new IllegalStateException("not yet supported");
            }
            JsonSchema arraySchema = jacksonSchema.asArraySchema().getItems().asSingleItems().getSchema();
            T schema = this.resolveProperty(visited, schemaSwaps, name, type.getContentType(), arraySchema);
            return this.arrayLikeProperty(schema);
        }
        if (jacksonSchema.isIntegerSchema()) {
            return this.singleProperty("integer");
        }
        if (jacksonSchema.isNumberSchema()) {
            return this.singleProperty("number");
        }
        if (jacksonSchema.isBooleanSchema()) {
            return this.singleProperty("boolean");
        }
        if (jacksonSchema.isStringSchema()) {
            StringSchema stringSchema = jacksonSchema.asStringSchema();
            if (!stringSchema.getEnums().isEmpty()) {
                Set ignores = type.isEnumType() ? this.findIgnoredEnumConstants(type) : Collections.emptySet();
                JsonNode[] enumValues = (JsonNode[])stringSchema.getEnums().stream().sorted().filter(s -> !ignores.contains(s)).map(arg_0 -> ((JsonNodeFactory)JsonNodeFactory.instance).textNode(arg_0)).toArray(JsonNode[]::new);
                return this.enumProperty(enumValues);
            }
            return this.singleProperty("string");
        }
        if (jacksonSchema.isNullSchema()) {
            return this.singleProperty("object");
        }
        if (jacksonSchema.isAnySchema()) {
            if (type.getRawClass() == IntOrString.class || type.getRawClass() == Quantity.class) {
                return this.intOrString();
            }
            if (type.getRawClass() == RawExtension.class) {
                return this.raw();
            }
            T schema = this.singleProperty(null);
            schema.setXKubernetesPreserveUnknownFields(true);
            return schema;
        }
        if (jacksonSchema.isUnionTypeSchema()) {
            throw new IllegalStateException("not yet supported");
        }
        if (jacksonSchema instanceof ReferenceSchema) {
            ReferenceSchema ref = (ReferenceSchema)jacksonSchema;
            ResolvingContext.GeneratorObjectSchema referenced = this.resolvingContext.uriToJacksonSchema.get(ref.get$ref());
            Utils.checkNotNull((Object)((Object)referenced), (String)"Could not find previously generated schema");
            jacksonSchema = referenced;
        } else if (type.isMapLikeType()) {
            JavaType keyType = type.getKeyType();
            if (keyType.getRawClass() != String.class) {
                LOGGER.warn("Property '{}' with '{}' key type is mapped to 'string' because of CRD schemas limitations", (Object)name, (Object)keyType);
            }
            JavaType valueType = type.getContentType();
            JsonSchema mapValueSchema = ((ObjectSchema.SchemaAdditionalProperties)((ObjectSchema)jacksonSchema).getAdditionalProperties()).getJsonSchema();
            T component = this.resolveProperty(visited, schemaSwaps, name, valueType, mapValueSchema);
            return this.mapLikeProperty(component);
        }
        Class def = type.getRawClass();
        if (def == GenericKubernetesResource.class || def.isInterface() && HasMetadata.class.isAssignableFrom(def)) {
            return this.raw();
        }
        if (visited.put(def.getName(), name) != null) {
            throw new IllegalArgumentException("Found a cyclic reference involving the field of type " + def.getName() + " starting a field " + visited.entrySet().stream().map(e -> (String)e.getValue() + " >>\n" + (String)e.getKey()).collect(Collectors.joining(".")) + "." + name);
        }
        T res = this.resolveObject(visited, schemaSwaps, (JsonSchema)jacksonSchema, new String[0]);
        visited.remove(def.getName());
        return res;
    }

    private Set<String> findIgnoredEnumConstants(JavaType type) {
        Field[] fields = type.getRawClass().getFields();
        HashSet<String> toIgnore = new HashSet<String>();
        for (Field field : fields) {
            if (!field.isEnumConstant() || field.getAnnotation(JsonIgnore.class) == null) continue;
            try {
                Object value = field.get(null);
                toIgnore.add((String)this.resolvingContext.objectMapper.convertValue(value, String.class));
            }
            catch (IllegalAccessException | IllegalArgumentException exception) {
                // empty catch block
            }
        }
        return toIgnore;
    }

    V from(ValidationRule validationRule) {
        V result = this.newKubernetesValidationRule();
        result.setRule(validationRule.value());
        result.setReason(AbstractJsonSchema.mapNotEmpty(validationRule.reason()));
        result.setMessage(AbstractJsonSchema.mapNotEmpty(validationRule.message()));
        result.setMessageExpression(AbstractJsonSchema.mapNotEmpty(validationRule.messageExpression()));
        result.setFieldPath(AbstractJsonSchema.mapNotEmpty(validationRule.fieldPath()));
        result.setOptionalOldSelf(validationRule.optionalOldSelf() ? Boolean.valueOf(true) : null);
        return result;
    }

    private static String mapNotEmpty(String s) {
        return Utils.isNullOrEmpty((String)s) ? null : s;
    }

    protected abstract V newKubernetesValidationRule();

    protected abstract void addProperty(String var1, T var2, T var3);

    protected abstract T intOrString();

    protected abstract T arrayLikeProperty(T var1);

    protected abstract T mapLikeProperty(T var1);

    protected abstract T singleProperty(String var1);

    protected abstract T enumProperty(JsonNode ... var1);

    protected abstract void addToValidationRules(T var1, List<V> var2);

    protected abstract T raw();

    class PropertyMetadata {
        private boolean required;
        private String description;
        private String defaultValue;
        private Double min;
        private Double max;
        private String pattern;
        private boolean nullable;
        private String format;
        private List<V> validationRules = new ArrayList();
        private boolean preserveUnknownFields;
        private Class<?> schemaFrom;

        public PropertyMetadata(JsonSchema value, BeanProperty beanProperty) {
            this.required = Boolean.TRUE.equals(value.getRequired());
            this.description = beanProperty.getMetadata().getDescription();
            this.defaultValue = beanProperty.getMetadata().getDefaultValue();
            this.schemaFrom = Optional.ofNullable(beanProperty.getAnnotation(SchemaFrom.class)).map(SchemaFrom::type).orElse(null);
            boolean bl = this.preserveUnknownFields = beanProperty.getAnnotation(PreserveUnknownFields.class) != null;
            if (value.isValueTypeSchema()) {
                ValueTypeSchema valueTypeSchema = value.asValueTypeSchema();
                this.format = Optional.ofNullable(valueTypeSchema.getFormat()).map(Object::toString).orElse(null);
            }
            if (value.isStringSchema()) {
                StringSchema stringSchema = value.asStringSchema();
                this.pattern = stringSchema.getPattern();
                this.max = Optional.ofNullable(stringSchema.getMaxLength()).map(Integer::doubleValue).orElse(null);
                this.min = Optional.ofNullable(stringSchema.getMinLength()).map(Integer::doubleValue).orElse(null);
            }
            AbstractJsonSchema.this.collectValidationRules(beanProperty, this.validationRules);
            this.nullable = beanProperty.getAnnotation(Nullable.class) != null;
            this.max = Optional.ofNullable(beanProperty.getAnnotation(Max.class)).map(Max::value).orElse(this.max);
            this.min = Optional.ofNullable(beanProperty.getAnnotation(Min.class)).map(Min::value).orElse(this.min);
            this.required = beanProperty.getAnnotation(Required.class) != null;
            this.defaultValue = Optional.ofNullable(beanProperty.getAnnotation(Default.class)).map(Default::value).orElse(this.defaultValue);
            this.pattern = Optional.ofNullable(beanProperty.getAnnotation(Pattern.class)).map(Pattern::value).orElse(this.pattern);
        }

        public void updateSchema(T schema) {
            schema.setDescription(this.description);
            if (this.defaultValue != null) {
                try {
                    schema.setDefault((JsonNode)((AbstractJsonSchema)AbstractJsonSchema.this).resolvingContext.kubernetesSerialization.convertValue((Object)this.defaultValue, JsonNode.class));
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalArgumentException("Cannot parse default value: '" + this.defaultValue + "' as valid YAML.", e);
                }
            }
            if (this.nullable) {
                schema.setNullable(this.nullable);
            }
            schema.setMaximum(this.max);
            schema.setMinimum(this.min);
            schema.setPattern(this.pattern);
            schema.setFormat(this.format);
            if (this.preserveUnknownFields) {
                schema.setXKubernetesPreserveUnknownFields(true);
            }
            AbstractJsonSchema.this.addToValidationRules(schema, this.validationRules);
        }
    }

    public static class AnnotationMetadata {
        public final Annotation annotation;
        public final KubernetesJSONSchemaProps schema;

        public AnnotationMetadata(Annotation annotation, KubernetesJSONSchemaProps schema) {
            this.annotation = annotation;
            this.schema = schema;
        }
    }
}

