package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class WorkflowStatusFluent<A extends WorkflowStatusFluent<A>> extends BaseFluent<A>{
  public WorkflowStatusFluent() {
  }
  
  public WorkflowStatusFluent(WorkflowStatus instance) {
    this.copyInstance(instance);
  }
  private ArrayList<WorkflowConditionBuilder> conditions = new ArrayList<WorkflowConditionBuilder>();
  private String endTime;
  private String entryNode;
  private String startTime;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(WorkflowStatus instance) {
    instance = (instance != null ? instance : new WorkflowStatus());
    if (instance != null) {
          this.withConditions(instance.getConditions());
          this.withEndTime(instance.getEndTime());
          this.withEntryNode(instance.getEntryNode());
          this.withStartTime(instance.getStartTime());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public A addToConditions(int index,WorkflowCondition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<WorkflowConditionBuilder>();}
    WorkflowConditionBuilder builder = new WorkflowConditionBuilder(item);
    if (index < 0 || index >= conditions.size()) {
        _visitables.get("conditions").add(builder);
        conditions.add(builder);
    } else {
        _visitables.get("conditions").add(builder);
        conditions.add(index, builder);
    }
    return (A)this;
  }
  
  public A setToConditions(int index,WorkflowCondition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<WorkflowConditionBuilder>();}
    WorkflowConditionBuilder builder = new WorkflowConditionBuilder(item);
    if (index < 0 || index >= conditions.size()) {
        _visitables.get("conditions").add(builder);
        conditions.add(builder);
    } else {
        _visitables.get("conditions").add(builder);
        conditions.set(index, builder);
    }
    return (A)this;
  }
  
  public A addToConditions(io.fabric8.chaosmesh.v1alpha1.WorkflowCondition... items) {
    if (this.conditions == null) {this.conditions = new ArrayList<WorkflowConditionBuilder>();}
    for (WorkflowCondition item : items) {WorkflowConditionBuilder builder = new WorkflowConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  
  public A addAllToConditions(Collection<WorkflowCondition> items) {
    if (this.conditions == null) {this.conditions = new ArrayList<WorkflowConditionBuilder>();}
    for (WorkflowCondition item : items) {WorkflowConditionBuilder builder = new WorkflowConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  
  public A removeFromConditions(io.fabric8.chaosmesh.v1alpha1.WorkflowCondition... items) {
    if (this.conditions == null) return (A)this;
    for (WorkflowCondition item : items) {WorkflowConditionBuilder builder = new WorkflowConditionBuilder(item);_visitables.get("conditions").remove(builder); this.conditions.remove(builder);} return (A)this;
  }
  
  public A removeAllFromConditions(Collection<WorkflowCondition> items) {
    if (this.conditions == null) return (A)this;
    for (WorkflowCondition item : items) {WorkflowConditionBuilder builder = new WorkflowConditionBuilder(item);_visitables.get("conditions").remove(builder); this.conditions.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromConditions(Predicate<WorkflowConditionBuilder> predicate) {
    if (conditions == null) return (A) this;
    final Iterator<WorkflowConditionBuilder> each = conditions.iterator();
    final List visitables = _visitables.get("conditions");
    while (each.hasNext()) {
      WorkflowConditionBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<WorkflowCondition> buildConditions() {
    return this.conditions != null ? build(conditions) : null;
  }
  
  public WorkflowCondition buildCondition(int index) {
    return this.conditions.get(index).build();
  }
  
  public WorkflowCondition buildFirstCondition() {
    return this.conditions.get(0).build();
  }
  
  public WorkflowCondition buildLastCondition() {
    return this.conditions.get(conditions.size() - 1).build();
  }
  
  public WorkflowCondition buildMatchingCondition(Predicate<WorkflowConditionBuilder> predicate) {
      for (WorkflowConditionBuilder item : conditions) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingCondition(Predicate<WorkflowConditionBuilder> predicate) {
      for (WorkflowConditionBuilder item : conditions) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withConditions(List<WorkflowCondition> conditions) {
    if (this.conditions != null) {
      this._visitables.get("conditions").clear();
    }
    if (conditions != null) {
        this.conditions = new ArrayList();
        for (WorkflowCondition item : conditions) {
          this.addToConditions(item);
        }
    } else {
      this.conditions = null;
    }
    return (A) this;
  }
  
  public A withConditions(io.fabric8.chaosmesh.v1alpha1.WorkflowCondition... conditions) {
    if (this.conditions != null) {
        this.conditions.clear();
        _visitables.remove("conditions");
    }
    if (conditions != null) {
      for (WorkflowCondition item : conditions) {
        this.addToConditions(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasConditions() {
    return this.conditions != null && !this.conditions.isEmpty();
  }
  
  public A addNewCondition(String reason,String startTime,String status,String type) {
    return (A)addToConditions(new WorkflowCondition(reason, startTime, status, type));
  }
  
  public ConditionsNested<A> addNewCondition() {
    return new ConditionsNested(-1, null);
  }
  
  public ConditionsNested<A> addNewConditionLike(WorkflowCondition item) {
    return new ConditionsNested(-1, item);
  }
  
  public ConditionsNested<A> setNewConditionLike(int index,WorkflowCondition item) {
    return new ConditionsNested(index, item);
  }
  
  public ConditionsNested<A> editCondition(int index) {
    if (conditions.size() <= index) throw new RuntimeException("Can't edit conditions. Index exceeds size.");
    return setNewConditionLike(index, buildCondition(index));
  }
  
  public ConditionsNested<A> editFirstCondition() {
    if (conditions.size() == 0) throw new RuntimeException("Can't edit first conditions. The list is empty.");
    return setNewConditionLike(0, buildCondition(0));
  }
  
  public ConditionsNested<A> editLastCondition() {
    int index = conditions.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last conditions. The list is empty.");
    return setNewConditionLike(index, buildCondition(index));
  }
  
  public ConditionsNested<A> editMatchingCondition(Predicate<WorkflowConditionBuilder> predicate) {
    int index = -1;
    for (int i=0;i<conditions.size();i++) { 
    if (predicate.test(conditions.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching conditions. No match found.");
    return setNewConditionLike(index, buildCondition(index));
  }
  
  public String getEndTime() {
    return this.endTime;
  }
  
  public A withEndTime(String endTime) {
    this.endTime = endTime;
    return (A) this;
  }
  
  public boolean hasEndTime() {
    return this.endTime != null;
  }
  
  public String getEntryNode() {
    return this.entryNode;
  }
  
  public A withEntryNode(String entryNode) {
    this.entryNode = entryNode;
    return (A) this;
  }
  
  public boolean hasEntryNode() {
    return this.entryNode != null;
  }
  
  public String getStartTime() {
    return this.startTime;
  }
  
  public A withStartTime(String startTime) {
    this.startTime = startTime;
    return (A) this;
  }
  
  public boolean hasStartTime() {
    return this.startTime != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    WorkflowStatusFluent that = (WorkflowStatusFluent) o;
    if (!java.util.Objects.equals(conditions, that.conditions)) return false;
    if (!java.util.Objects.equals(endTime, that.endTime)) return false;
    if (!java.util.Objects.equals(entryNode, that.entryNode)) return false;
    if (!java.util.Objects.equals(startTime, that.startTime)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(conditions,  endTime,  entryNode,  startTime,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (conditions != null && !conditions.isEmpty()) { sb.append("conditions:"); sb.append(conditions + ","); }
    if (endTime != null) { sb.append("endTime:"); sb.append(endTime + ","); }
    if (entryNode != null) { sb.append("entryNode:"); sb.append(entryNode + ","); }
    if (startTime != null) { sb.append("startTime:"); sb.append(startTime + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class ConditionsNested<N> extends WorkflowConditionFluent<ConditionsNested<N>> implements Nested<N>{
    ConditionsNested(int index,WorkflowCondition item) {
      this.index = index;
      this.builder = new WorkflowConditionBuilder(this, item);
    }
    WorkflowConditionBuilder builder;
    int index;
    
    public N and() {
      return (N) WorkflowStatusFluent.this.setToConditions(index,builder.build());
    }
    
    public N endCondition() {
      return and();
    }
    
  
  }

}