package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class WorkflowSpecFluent<A extends WorkflowSpecFluent<A>> extends BaseFluent<A>{
  public WorkflowSpecFluent() {
  }
  
  public WorkflowSpecFluent(WorkflowSpec instance) {
    this.copyInstance(instance);
  }
  private String entry;
  private ArrayList<TemplateBuilder> templates = new ArrayList<TemplateBuilder>();
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(WorkflowSpec instance) {
    instance = (instance != null ? instance : new WorkflowSpec());
    if (instance != null) {
          this.withEntry(instance.getEntry());
          this.withTemplates(instance.getTemplates());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public String getEntry() {
    return this.entry;
  }
  
  public A withEntry(String entry) {
    this.entry = entry;
    return (A) this;
  }
  
  public boolean hasEntry() {
    return this.entry != null;
  }
  
  public A addToTemplates(int index,Template item) {
    if (this.templates == null) {this.templates = new ArrayList<TemplateBuilder>();}
    TemplateBuilder builder = new TemplateBuilder(item);
    if (index < 0 || index >= templates.size()) {
        _visitables.get("templates").add(builder);
        templates.add(builder);
    } else {
        _visitables.get("templates").add(builder);
        templates.add(index, builder);
    }
    return (A)this;
  }
  
  public A setToTemplates(int index,Template item) {
    if (this.templates == null) {this.templates = new ArrayList<TemplateBuilder>();}
    TemplateBuilder builder = new TemplateBuilder(item);
    if (index < 0 || index >= templates.size()) {
        _visitables.get("templates").add(builder);
        templates.add(builder);
    } else {
        _visitables.get("templates").add(builder);
        templates.set(index, builder);
    }
    return (A)this;
  }
  
  public A addToTemplates(io.fabric8.chaosmesh.v1alpha1.Template... items) {
    if (this.templates == null) {this.templates = new ArrayList<TemplateBuilder>();}
    for (Template item : items) {TemplateBuilder builder = new TemplateBuilder(item);_visitables.get("templates").add(builder);this.templates.add(builder);} return (A)this;
  }
  
  public A addAllToTemplates(Collection<Template> items) {
    if (this.templates == null) {this.templates = new ArrayList<TemplateBuilder>();}
    for (Template item : items) {TemplateBuilder builder = new TemplateBuilder(item);_visitables.get("templates").add(builder);this.templates.add(builder);} return (A)this;
  }
  
  public A removeFromTemplates(io.fabric8.chaosmesh.v1alpha1.Template... items) {
    if (this.templates == null) return (A)this;
    for (Template item : items) {TemplateBuilder builder = new TemplateBuilder(item);_visitables.get("templates").remove(builder); this.templates.remove(builder);} return (A)this;
  }
  
  public A removeAllFromTemplates(Collection<Template> items) {
    if (this.templates == null) return (A)this;
    for (Template item : items) {TemplateBuilder builder = new TemplateBuilder(item);_visitables.get("templates").remove(builder); this.templates.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromTemplates(Predicate<TemplateBuilder> predicate) {
    if (templates == null) return (A) this;
    final Iterator<TemplateBuilder> each = templates.iterator();
    final List visitables = _visitables.get("templates");
    while (each.hasNext()) {
      TemplateBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<Template> buildTemplates() {
    return this.templates != null ? build(templates) : null;
  }
  
  public Template buildTemplate(int index) {
    return this.templates.get(index).build();
  }
  
  public Template buildFirstTemplate() {
    return this.templates.get(0).build();
  }
  
  public Template buildLastTemplate() {
    return this.templates.get(templates.size() - 1).build();
  }
  
  public Template buildMatchingTemplate(Predicate<TemplateBuilder> predicate) {
      for (TemplateBuilder item : templates) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingTemplate(Predicate<TemplateBuilder> predicate) {
      for (TemplateBuilder item : templates) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withTemplates(List<Template> templates) {
    if (this.templates != null) {
      this._visitables.get("templates").clear();
    }
    if (templates != null) {
        this.templates = new ArrayList();
        for (Template item : templates) {
          this.addToTemplates(item);
        }
    } else {
      this.templates = null;
    }
    return (A) this;
  }
  
  public A withTemplates(io.fabric8.chaosmesh.v1alpha1.Template... templates) {
    if (this.templates != null) {
        this.templates.clear();
        _visitables.remove("templates");
    }
    if (templates != null) {
      for (Template item : templates) {
        this.addToTemplates(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasTemplates() {
    return this.templates != null && !this.templates.isEmpty();
  }
  
  public TemplatesNested<A> addNewTemplate() {
    return new TemplatesNested(-1, null);
  }
  
  public TemplatesNested<A> addNewTemplateLike(Template item) {
    return new TemplatesNested(-1, item);
  }
  
  public TemplatesNested<A> setNewTemplateLike(int index,Template item) {
    return new TemplatesNested(index, item);
  }
  
  public TemplatesNested<A> editTemplate(int index) {
    if (templates.size() <= index) throw new RuntimeException("Can't edit templates. Index exceeds size.");
    return setNewTemplateLike(index, buildTemplate(index));
  }
  
  public TemplatesNested<A> editFirstTemplate() {
    if (templates.size() == 0) throw new RuntimeException("Can't edit first templates. The list is empty.");
    return setNewTemplateLike(0, buildTemplate(0));
  }
  
  public TemplatesNested<A> editLastTemplate() {
    int index = templates.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last templates. The list is empty.");
    return setNewTemplateLike(index, buildTemplate(index));
  }
  
  public TemplatesNested<A> editMatchingTemplate(Predicate<TemplateBuilder> predicate) {
    int index = -1;
    for (int i=0;i<templates.size();i++) { 
    if (predicate.test(templates.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching templates. No match found.");
    return setNewTemplateLike(index, buildTemplate(index));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    WorkflowSpecFluent that = (WorkflowSpecFluent) o;
    if (!java.util.Objects.equals(entry, that.entry)) return false;
    if (!java.util.Objects.equals(templates, that.templates)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(entry,  templates,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (entry != null) { sb.append("entry:"); sb.append(entry + ","); }
    if (templates != null && !templates.isEmpty()) { sb.append("templates:"); sb.append(templates + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class TemplatesNested<N> extends TemplateFluent<TemplatesNested<N>> implements Nested<N>{
    TemplatesNested(int index,Template item) {
      this.index = index;
      this.builder = new TemplateBuilder(this, item);
    }
    TemplateBuilder builder;
    int index;
    
    public N and() {
      return (N) WorkflowSpecFluent.this.setToTemplates(index,builder.build());
    }
    
    public N endTemplate() {
      return and();
    }
    
  
  }

}