package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import io.fabric8.kubernetes.api.model.TypedLocalObjectReference;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluent;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class WorkflowNodeStatusFluent<A extends WorkflowNodeStatusFluent<A>> extends BaseFluent<A>{
  public WorkflowNodeStatusFluent() {
  }
  
  public WorkflowNodeStatusFluent(WorkflowNodeStatus instance) {
    this.copyInstance(instance);
  }
  private ArrayList<LocalObjectReferenceBuilder> activeChildren = new ArrayList<LocalObjectReferenceBuilder>();
  private TypedLocalObjectReference chaosResource;
  private ConditionalBranchesStatusBuilder conditionalBranchesStatus;
  private ArrayList<WorkflowNodeConditionBuilder> conditions = new ArrayList<WorkflowNodeConditionBuilder>();
  private ArrayList<LocalObjectReferenceBuilder> finishedChildren = new ArrayList<LocalObjectReferenceBuilder>();
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(WorkflowNodeStatus instance) {
    instance = (instance != null ? instance : new WorkflowNodeStatus());
    if (instance != null) {
          this.withActiveChildren(instance.getActiveChildren());
          this.withChaosResource(instance.getChaosResource());
          this.withConditionalBranchesStatus(instance.getConditionalBranchesStatus());
          this.withConditions(instance.getConditions());
          this.withFinishedChildren(instance.getFinishedChildren());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public A addToActiveChildren(int index,LocalObjectReference item) {
    if (this.activeChildren == null) {this.activeChildren = new ArrayList<LocalObjectReferenceBuilder>();}
    LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);
    if (index < 0 || index >= activeChildren.size()) {
        _visitables.get("activeChildren").add(builder);
        activeChildren.add(builder);
    } else {
        _visitables.get("activeChildren").add(builder);
        activeChildren.add(index, builder);
    }
    return (A)this;
  }
  
  public A setToActiveChildren(int index,LocalObjectReference item) {
    if (this.activeChildren == null) {this.activeChildren = new ArrayList<LocalObjectReferenceBuilder>();}
    LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);
    if (index < 0 || index >= activeChildren.size()) {
        _visitables.get("activeChildren").add(builder);
        activeChildren.add(builder);
    } else {
        _visitables.get("activeChildren").add(builder);
        activeChildren.set(index, builder);
    }
    return (A)this;
  }
  
  public A addToActiveChildren(io.fabric8.kubernetes.api.model.LocalObjectReference... items) {
    if (this.activeChildren == null) {this.activeChildren = new ArrayList<LocalObjectReferenceBuilder>();}
    for (LocalObjectReference item : items) {LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);_visitables.get("activeChildren").add(builder);this.activeChildren.add(builder);} return (A)this;
  }
  
  public A addAllToActiveChildren(Collection<LocalObjectReference> items) {
    if (this.activeChildren == null) {this.activeChildren = new ArrayList<LocalObjectReferenceBuilder>();}
    for (LocalObjectReference item : items) {LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);_visitables.get("activeChildren").add(builder);this.activeChildren.add(builder);} return (A)this;
  }
  
  public A removeFromActiveChildren(io.fabric8.kubernetes.api.model.LocalObjectReference... items) {
    if (this.activeChildren == null) return (A)this;
    for (LocalObjectReference item : items) {LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);_visitables.get("activeChildren").remove(builder); this.activeChildren.remove(builder);} return (A)this;
  }
  
  public A removeAllFromActiveChildren(Collection<LocalObjectReference> items) {
    if (this.activeChildren == null) return (A)this;
    for (LocalObjectReference item : items) {LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);_visitables.get("activeChildren").remove(builder); this.activeChildren.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromActiveChildren(Predicate<LocalObjectReferenceBuilder> predicate) {
    if (activeChildren == null) return (A) this;
    final Iterator<LocalObjectReferenceBuilder> each = activeChildren.iterator();
    final List visitables = _visitables.get("activeChildren");
    while (each.hasNext()) {
      LocalObjectReferenceBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<LocalObjectReference> buildActiveChildren() {
    return this.activeChildren != null ? build(activeChildren) : null;
  }
  
  public LocalObjectReference buildActiveChild(int index) {
    return this.activeChildren.get(index).build();
  }
  
  public LocalObjectReference buildFirstActiveChild() {
    return this.activeChildren.get(0).build();
  }
  
  public LocalObjectReference buildLastActiveChild() {
    return this.activeChildren.get(activeChildren.size() - 1).build();
  }
  
  public LocalObjectReference buildMatchingActiveChild(Predicate<LocalObjectReferenceBuilder> predicate) {
      for (LocalObjectReferenceBuilder item : activeChildren) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingActiveChild(Predicate<LocalObjectReferenceBuilder> predicate) {
      for (LocalObjectReferenceBuilder item : activeChildren) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withActiveChildren(List<LocalObjectReference> activeChildren) {
    if (this.activeChildren != null) {
      this._visitables.get("activeChildren").clear();
    }
    if (activeChildren != null) {
        this.activeChildren = new ArrayList();
        for (LocalObjectReference item : activeChildren) {
          this.addToActiveChildren(item);
        }
    } else {
      this.activeChildren = null;
    }
    return (A) this;
  }
  
  public A withActiveChildren(io.fabric8.kubernetes.api.model.LocalObjectReference... activeChildren) {
    if (this.activeChildren != null) {
        this.activeChildren.clear();
        _visitables.remove("activeChildren");
    }
    if (activeChildren != null) {
      for (LocalObjectReference item : activeChildren) {
        this.addToActiveChildren(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasActiveChildren() {
    return this.activeChildren != null && !this.activeChildren.isEmpty();
  }
  
  public A addNewActiveChild(String name) {
    return (A)addToActiveChildren(new LocalObjectReference(name));
  }
  
  public ActiveChildrenNested<A> addNewActiveChild() {
    return new ActiveChildrenNested(-1, null);
  }
  
  public ActiveChildrenNested<A> addNewActiveChildLike(LocalObjectReference item) {
    return new ActiveChildrenNested(-1, item);
  }
  
  public ActiveChildrenNested<A> setNewActiveChildLike(int index,LocalObjectReference item) {
    return new ActiveChildrenNested(index, item);
  }
  
  public ActiveChildrenNested<A> editActiveChild(int index) {
    if (activeChildren.size() <= index) throw new RuntimeException("Can't edit activeChildren. Index exceeds size.");
    return setNewActiveChildLike(index, buildActiveChild(index));
  }
  
  public ActiveChildrenNested<A> editFirstActiveChild() {
    if (activeChildren.size() == 0) throw new RuntimeException("Can't edit first activeChildren. The list is empty.");
    return setNewActiveChildLike(0, buildActiveChild(0));
  }
  
  public ActiveChildrenNested<A> editLastActiveChild() {
    int index = activeChildren.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last activeChildren. The list is empty.");
    return setNewActiveChildLike(index, buildActiveChild(index));
  }
  
  public ActiveChildrenNested<A> editMatchingActiveChild(Predicate<LocalObjectReferenceBuilder> predicate) {
    int index = -1;
    for (int i=0;i<activeChildren.size();i++) { 
    if (predicate.test(activeChildren.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching activeChildren. No match found.");
    return setNewActiveChildLike(index, buildActiveChild(index));
  }
  
  public TypedLocalObjectReference getChaosResource() {
    return this.chaosResource;
  }
  
  public A withChaosResource(TypedLocalObjectReference chaosResource) {
    this.chaosResource = chaosResource;
    return (A) this;
  }
  
  public boolean hasChaosResource() {
    return this.chaosResource != null;
  }
  
  public A withNewChaosResource(String apiGroup,String kind,String name) {
    return (A)withChaosResource(new TypedLocalObjectReference(apiGroup, kind, name));
  }
  
  public ConditionalBranchesStatus buildConditionalBranchesStatus() {
    return this.conditionalBranchesStatus != null ? this.conditionalBranchesStatus.build() : null;
  }
  
  public A withConditionalBranchesStatus(ConditionalBranchesStatus conditionalBranchesStatus) {
    this._visitables.remove("conditionalBranchesStatus");
    if (conditionalBranchesStatus != null) {
        this.conditionalBranchesStatus = new ConditionalBranchesStatusBuilder(conditionalBranchesStatus);
        this._visitables.get("conditionalBranchesStatus").add(this.conditionalBranchesStatus);
    } else {
        this.conditionalBranchesStatus = null;
        this._visitables.get("conditionalBranchesStatus").remove(this.conditionalBranchesStatus);
    }
    return (A) this;
  }
  
  public boolean hasConditionalBranchesStatus() {
    return this.conditionalBranchesStatus != null;
  }
  
  public ConditionalBranchesStatusNested<A> withNewConditionalBranchesStatus() {
    return new ConditionalBranchesStatusNested(null);
  }
  
  public ConditionalBranchesStatusNested<A> withNewConditionalBranchesStatusLike(ConditionalBranchesStatus item) {
    return new ConditionalBranchesStatusNested(item);
  }
  
  public ConditionalBranchesStatusNested<A> editConditionalBranchesStatus() {
    return withNewConditionalBranchesStatusLike(java.util.Optional.ofNullable(buildConditionalBranchesStatus()).orElse(null));
  }
  
  public ConditionalBranchesStatusNested<A> editOrNewConditionalBranchesStatus() {
    return withNewConditionalBranchesStatusLike(java.util.Optional.ofNullable(buildConditionalBranchesStatus()).orElse(new ConditionalBranchesStatusBuilder().build()));
  }
  
  public ConditionalBranchesStatusNested<A> editOrNewConditionalBranchesStatusLike(ConditionalBranchesStatus item) {
    return withNewConditionalBranchesStatusLike(java.util.Optional.ofNullable(buildConditionalBranchesStatus()).orElse(item));
  }
  
  public A addToConditions(int index,WorkflowNodeCondition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<WorkflowNodeConditionBuilder>();}
    WorkflowNodeConditionBuilder builder = new WorkflowNodeConditionBuilder(item);
    if (index < 0 || index >= conditions.size()) {
        _visitables.get("conditions").add(builder);
        conditions.add(builder);
    } else {
        _visitables.get("conditions").add(builder);
        conditions.add(index, builder);
    }
    return (A)this;
  }
  
  public A setToConditions(int index,WorkflowNodeCondition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<WorkflowNodeConditionBuilder>();}
    WorkflowNodeConditionBuilder builder = new WorkflowNodeConditionBuilder(item);
    if (index < 0 || index >= conditions.size()) {
        _visitables.get("conditions").add(builder);
        conditions.add(builder);
    } else {
        _visitables.get("conditions").add(builder);
        conditions.set(index, builder);
    }
    return (A)this;
  }
  
  public A addToConditions(io.fabric8.chaosmesh.v1alpha1.WorkflowNodeCondition... items) {
    if (this.conditions == null) {this.conditions = new ArrayList<WorkflowNodeConditionBuilder>();}
    for (WorkflowNodeCondition item : items) {WorkflowNodeConditionBuilder builder = new WorkflowNodeConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  
  public A addAllToConditions(Collection<WorkflowNodeCondition> items) {
    if (this.conditions == null) {this.conditions = new ArrayList<WorkflowNodeConditionBuilder>();}
    for (WorkflowNodeCondition item : items) {WorkflowNodeConditionBuilder builder = new WorkflowNodeConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  
  public A removeFromConditions(io.fabric8.chaosmesh.v1alpha1.WorkflowNodeCondition... items) {
    if (this.conditions == null) return (A)this;
    for (WorkflowNodeCondition item : items) {WorkflowNodeConditionBuilder builder = new WorkflowNodeConditionBuilder(item);_visitables.get("conditions").remove(builder); this.conditions.remove(builder);} return (A)this;
  }
  
  public A removeAllFromConditions(Collection<WorkflowNodeCondition> items) {
    if (this.conditions == null) return (A)this;
    for (WorkflowNodeCondition item : items) {WorkflowNodeConditionBuilder builder = new WorkflowNodeConditionBuilder(item);_visitables.get("conditions").remove(builder); this.conditions.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromConditions(Predicate<WorkflowNodeConditionBuilder> predicate) {
    if (conditions == null) return (A) this;
    final Iterator<WorkflowNodeConditionBuilder> each = conditions.iterator();
    final List visitables = _visitables.get("conditions");
    while (each.hasNext()) {
      WorkflowNodeConditionBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<WorkflowNodeCondition> buildConditions() {
    return this.conditions != null ? build(conditions) : null;
  }
  
  public WorkflowNodeCondition buildCondition(int index) {
    return this.conditions.get(index).build();
  }
  
  public WorkflowNodeCondition buildFirstCondition() {
    return this.conditions.get(0).build();
  }
  
  public WorkflowNodeCondition buildLastCondition() {
    return this.conditions.get(conditions.size() - 1).build();
  }
  
  public WorkflowNodeCondition buildMatchingCondition(Predicate<WorkflowNodeConditionBuilder> predicate) {
      for (WorkflowNodeConditionBuilder item : conditions) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingCondition(Predicate<WorkflowNodeConditionBuilder> predicate) {
      for (WorkflowNodeConditionBuilder item : conditions) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withConditions(List<WorkflowNodeCondition> conditions) {
    if (this.conditions != null) {
      this._visitables.get("conditions").clear();
    }
    if (conditions != null) {
        this.conditions = new ArrayList();
        for (WorkflowNodeCondition item : conditions) {
          this.addToConditions(item);
        }
    } else {
      this.conditions = null;
    }
    return (A) this;
  }
  
  public A withConditions(io.fabric8.chaosmesh.v1alpha1.WorkflowNodeCondition... conditions) {
    if (this.conditions != null) {
        this.conditions.clear();
        _visitables.remove("conditions");
    }
    if (conditions != null) {
      for (WorkflowNodeCondition item : conditions) {
        this.addToConditions(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasConditions() {
    return this.conditions != null && !this.conditions.isEmpty();
  }
  
  public A addNewCondition(String reason,String status,String type) {
    return (A)addToConditions(new WorkflowNodeCondition(reason, status, type));
  }
  
  public ConditionsNested<A> addNewCondition() {
    return new ConditionsNested(-1, null);
  }
  
  public ConditionsNested<A> addNewConditionLike(WorkflowNodeCondition item) {
    return new ConditionsNested(-1, item);
  }
  
  public ConditionsNested<A> setNewConditionLike(int index,WorkflowNodeCondition item) {
    return new ConditionsNested(index, item);
  }
  
  public ConditionsNested<A> editCondition(int index) {
    if (conditions.size() <= index) throw new RuntimeException("Can't edit conditions. Index exceeds size.");
    return setNewConditionLike(index, buildCondition(index));
  }
  
  public ConditionsNested<A> editFirstCondition() {
    if (conditions.size() == 0) throw new RuntimeException("Can't edit first conditions. The list is empty.");
    return setNewConditionLike(0, buildCondition(0));
  }
  
  public ConditionsNested<A> editLastCondition() {
    int index = conditions.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last conditions. The list is empty.");
    return setNewConditionLike(index, buildCondition(index));
  }
  
  public ConditionsNested<A> editMatchingCondition(Predicate<WorkflowNodeConditionBuilder> predicate) {
    int index = -1;
    for (int i=0;i<conditions.size();i++) { 
    if (predicate.test(conditions.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching conditions. No match found.");
    return setNewConditionLike(index, buildCondition(index));
  }
  
  public A addToFinishedChildren(int index,LocalObjectReference item) {
    if (this.finishedChildren == null) {this.finishedChildren = new ArrayList<LocalObjectReferenceBuilder>();}
    LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);
    if (index < 0 || index >= finishedChildren.size()) {
        _visitables.get("finishedChildren").add(builder);
        finishedChildren.add(builder);
    } else {
        _visitables.get("finishedChildren").add(builder);
        finishedChildren.add(index, builder);
    }
    return (A)this;
  }
  
  public A setToFinishedChildren(int index,LocalObjectReference item) {
    if (this.finishedChildren == null) {this.finishedChildren = new ArrayList<LocalObjectReferenceBuilder>();}
    LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);
    if (index < 0 || index >= finishedChildren.size()) {
        _visitables.get("finishedChildren").add(builder);
        finishedChildren.add(builder);
    } else {
        _visitables.get("finishedChildren").add(builder);
        finishedChildren.set(index, builder);
    }
    return (A)this;
  }
  
  public A addToFinishedChildren(io.fabric8.kubernetes.api.model.LocalObjectReference... items) {
    if (this.finishedChildren == null) {this.finishedChildren = new ArrayList<LocalObjectReferenceBuilder>();}
    for (LocalObjectReference item : items) {LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);_visitables.get("finishedChildren").add(builder);this.finishedChildren.add(builder);} return (A)this;
  }
  
  public A addAllToFinishedChildren(Collection<LocalObjectReference> items) {
    if (this.finishedChildren == null) {this.finishedChildren = new ArrayList<LocalObjectReferenceBuilder>();}
    for (LocalObjectReference item : items) {LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);_visitables.get("finishedChildren").add(builder);this.finishedChildren.add(builder);} return (A)this;
  }
  
  public A removeFromFinishedChildren(io.fabric8.kubernetes.api.model.LocalObjectReference... items) {
    if (this.finishedChildren == null) return (A)this;
    for (LocalObjectReference item : items) {LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);_visitables.get("finishedChildren").remove(builder); this.finishedChildren.remove(builder);} return (A)this;
  }
  
  public A removeAllFromFinishedChildren(Collection<LocalObjectReference> items) {
    if (this.finishedChildren == null) return (A)this;
    for (LocalObjectReference item : items) {LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);_visitables.get("finishedChildren").remove(builder); this.finishedChildren.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromFinishedChildren(Predicate<LocalObjectReferenceBuilder> predicate) {
    if (finishedChildren == null) return (A) this;
    final Iterator<LocalObjectReferenceBuilder> each = finishedChildren.iterator();
    final List visitables = _visitables.get("finishedChildren");
    while (each.hasNext()) {
      LocalObjectReferenceBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<LocalObjectReference> buildFinishedChildren() {
    return this.finishedChildren != null ? build(finishedChildren) : null;
  }
  
  public LocalObjectReference buildFinishedChild(int index) {
    return this.finishedChildren.get(index).build();
  }
  
  public LocalObjectReference buildFirstFinishedChild() {
    return this.finishedChildren.get(0).build();
  }
  
  public LocalObjectReference buildLastFinishedChild() {
    return this.finishedChildren.get(finishedChildren.size() - 1).build();
  }
  
  public LocalObjectReference buildMatchingFinishedChild(Predicate<LocalObjectReferenceBuilder> predicate) {
      for (LocalObjectReferenceBuilder item : finishedChildren) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingFinishedChild(Predicate<LocalObjectReferenceBuilder> predicate) {
      for (LocalObjectReferenceBuilder item : finishedChildren) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withFinishedChildren(List<LocalObjectReference> finishedChildren) {
    if (this.finishedChildren != null) {
      this._visitables.get("finishedChildren").clear();
    }
    if (finishedChildren != null) {
        this.finishedChildren = new ArrayList();
        for (LocalObjectReference item : finishedChildren) {
          this.addToFinishedChildren(item);
        }
    } else {
      this.finishedChildren = null;
    }
    return (A) this;
  }
  
  public A withFinishedChildren(io.fabric8.kubernetes.api.model.LocalObjectReference... finishedChildren) {
    if (this.finishedChildren != null) {
        this.finishedChildren.clear();
        _visitables.remove("finishedChildren");
    }
    if (finishedChildren != null) {
      for (LocalObjectReference item : finishedChildren) {
        this.addToFinishedChildren(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasFinishedChildren() {
    return this.finishedChildren != null && !this.finishedChildren.isEmpty();
  }
  
  public A addNewFinishedChild(String name) {
    return (A)addToFinishedChildren(new LocalObjectReference(name));
  }
  
  public FinishedChildrenNested<A> addNewFinishedChild() {
    return new FinishedChildrenNested(-1, null);
  }
  
  public FinishedChildrenNested<A> addNewFinishedChildLike(LocalObjectReference item) {
    return new FinishedChildrenNested(-1, item);
  }
  
  public FinishedChildrenNested<A> setNewFinishedChildLike(int index,LocalObjectReference item) {
    return new FinishedChildrenNested(index, item);
  }
  
  public FinishedChildrenNested<A> editFinishedChild(int index) {
    if (finishedChildren.size() <= index) throw new RuntimeException("Can't edit finishedChildren. Index exceeds size.");
    return setNewFinishedChildLike(index, buildFinishedChild(index));
  }
  
  public FinishedChildrenNested<A> editFirstFinishedChild() {
    if (finishedChildren.size() == 0) throw new RuntimeException("Can't edit first finishedChildren. The list is empty.");
    return setNewFinishedChildLike(0, buildFinishedChild(0));
  }
  
  public FinishedChildrenNested<A> editLastFinishedChild() {
    int index = finishedChildren.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last finishedChildren. The list is empty.");
    return setNewFinishedChildLike(index, buildFinishedChild(index));
  }
  
  public FinishedChildrenNested<A> editMatchingFinishedChild(Predicate<LocalObjectReferenceBuilder> predicate) {
    int index = -1;
    for (int i=0;i<finishedChildren.size();i++) { 
    if (predicate.test(finishedChildren.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching finishedChildren. No match found.");
    return setNewFinishedChildLike(index, buildFinishedChild(index));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    WorkflowNodeStatusFluent that = (WorkflowNodeStatusFluent) o;
    if (!java.util.Objects.equals(activeChildren, that.activeChildren)) return false;
    if (!java.util.Objects.equals(chaosResource, that.chaosResource)) return false;
    if (!java.util.Objects.equals(conditionalBranchesStatus, that.conditionalBranchesStatus)) return false;
    if (!java.util.Objects.equals(conditions, that.conditions)) return false;
    if (!java.util.Objects.equals(finishedChildren, that.finishedChildren)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(activeChildren,  chaosResource,  conditionalBranchesStatus,  conditions,  finishedChildren,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (activeChildren != null && !activeChildren.isEmpty()) { sb.append("activeChildren:"); sb.append(activeChildren + ","); }
    if (chaosResource != null) { sb.append("chaosResource:"); sb.append(chaosResource + ","); }
    if (conditionalBranchesStatus != null) { sb.append("conditionalBranchesStatus:"); sb.append(conditionalBranchesStatus + ","); }
    if (conditions != null && !conditions.isEmpty()) { sb.append("conditions:"); sb.append(conditions + ","); }
    if (finishedChildren != null && !finishedChildren.isEmpty()) { sb.append("finishedChildren:"); sb.append(finishedChildren + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class ActiveChildrenNested<N> extends LocalObjectReferenceFluent<ActiveChildrenNested<N>> implements Nested<N>{
    ActiveChildrenNested(int index,LocalObjectReference item) {
      this.index = index;
      this.builder = new LocalObjectReferenceBuilder(this, item);
    }
    LocalObjectReferenceBuilder builder;
    int index;
    
    public N and() {
      return (N) WorkflowNodeStatusFluent.this.setToActiveChildren(index,builder.build());
    }
    
    public N endActiveChild() {
      return and();
    }
    
  
  }
  public class ConditionalBranchesStatusNested<N> extends ConditionalBranchesStatusFluent<ConditionalBranchesStatusNested<N>> implements Nested<N>{
    ConditionalBranchesStatusNested(ConditionalBranchesStatus item) {
      this.builder = new ConditionalBranchesStatusBuilder(this, item);
    }
    ConditionalBranchesStatusBuilder builder;
    
    public N and() {
      return (N) WorkflowNodeStatusFluent.this.withConditionalBranchesStatus(builder.build());
    }
    
    public N endConditionalBranchesStatus() {
      return and();
    }
    
  
  }
  public class ConditionsNested<N> extends WorkflowNodeConditionFluent<ConditionsNested<N>> implements Nested<N>{
    ConditionsNested(int index,WorkflowNodeCondition item) {
      this.index = index;
      this.builder = new WorkflowNodeConditionBuilder(this, item);
    }
    WorkflowNodeConditionBuilder builder;
    int index;
    
    public N and() {
      return (N) WorkflowNodeStatusFluent.this.setToConditions(index,builder.build());
    }
    
    public N endCondition() {
      return and();
    }
    
  
  }
  public class FinishedChildrenNested<N> extends LocalObjectReferenceFluent<FinishedChildrenNested<N>> implements Nested<N>{
    FinishedChildrenNested(int index,LocalObjectReference item) {
      this.index = index;
      this.builder = new LocalObjectReferenceBuilder(this, item);
    }
    LocalObjectReferenceBuilder builder;
    int index;
    
    public N and() {
      return (N) WorkflowNodeStatusFluent.this.setToFinishedChildren(index,builder.build());
    }
    
    public N endFinishedChild() {
      return and();
    }
    
  
  }

}