package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class WorkflowNodeBuilder extends WorkflowNodeFluent<WorkflowNodeBuilder> implements VisitableBuilder<WorkflowNode,WorkflowNodeBuilder>{
  public WorkflowNodeBuilder() {
    this(new WorkflowNode());
  }
  
  public WorkflowNodeBuilder(WorkflowNodeFluent<?> fluent) {
    this(fluent, new WorkflowNode());
  }
  
  public WorkflowNodeBuilder(WorkflowNodeFluent<?> fluent,WorkflowNode instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public WorkflowNodeBuilder(WorkflowNode instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  WorkflowNodeFluent<?> fluent;
  
  public WorkflowNode build() {
    WorkflowNode buildable = new WorkflowNode(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildSpec(),fluent.buildStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}