package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.VolumeBuilder;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerBuilder;
import io.fabric8.kubernetes.api.model.ContainerFluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import io.fabric8.kubernetes.api.model.VolumeFluent;
import io.fabric8.kubernetes.api.model.Volume;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class TaskFluent<A extends TaskFluent<A>> extends BaseFluent<A>{
  public TaskFluent() {
  }
  
  public TaskFluent(Task instance) {
    this.copyInstance(instance);
  }
  private ContainerBuilder container;
  private ArrayList<VolumeBuilder> volumes = new ArrayList<VolumeBuilder>();
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(Task instance) {
    instance = (instance != null ? instance : new Task());
    if (instance != null) {
          this.withContainer(instance.getContainer());
          this.withVolumes(instance.getVolumes());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public Container buildContainer() {
    return this.container != null ? this.container.build() : null;
  }
  
  public A withContainer(Container container) {
    this._visitables.remove("container");
    if (container != null) {
        this.container = new ContainerBuilder(container);
        this._visitables.get("container").add(this.container);
    } else {
        this.container = null;
        this._visitables.get("container").remove(this.container);
    }
    return (A) this;
  }
  
  public boolean hasContainer() {
    return this.container != null;
  }
  
  public ContainerNested<A> withNewContainer() {
    return new ContainerNested(null);
  }
  
  public ContainerNested<A> withNewContainerLike(Container item) {
    return new ContainerNested(item);
  }
  
  public ContainerNested<A> editContainer() {
    return withNewContainerLike(java.util.Optional.ofNullable(buildContainer()).orElse(null));
  }
  
  public ContainerNested<A> editOrNewContainer() {
    return withNewContainerLike(java.util.Optional.ofNullable(buildContainer()).orElse(new ContainerBuilder().build()));
  }
  
  public ContainerNested<A> editOrNewContainerLike(Container item) {
    return withNewContainerLike(java.util.Optional.ofNullable(buildContainer()).orElse(item));
  }
  
  public A addToVolumes(int index,Volume item) {
    if (this.volumes == null) {this.volumes = new ArrayList<VolumeBuilder>();}
    VolumeBuilder builder = new VolumeBuilder(item);
    if (index < 0 || index >= volumes.size()) {
        _visitables.get("volumes").add(builder);
        volumes.add(builder);
    } else {
        _visitables.get("volumes").add(builder);
        volumes.add(index, builder);
    }
    return (A)this;
  }
  
  public A setToVolumes(int index,Volume item) {
    if (this.volumes == null) {this.volumes = new ArrayList<VolumeBuilder>();}
    VolumeBuilder builder = new VolumeBuilder(item);
    if (index < 0 || index >= volumes.size()) {
        _visitables.get("volumes").add(builder);
        volumes.add(builder);
    } else {
        _visitables.get("volumes").add(builder);
        volumes.set(index, builder);
    }
    return (A)this;
  }
  
  public A addToVolumes(io.fabric8.kubernetes.api.model.Volume... items) {
    if (this.volumes == null) {this.volumes = new ArrayList<VolumeBuilder>();}
    for (Volume item : items) {VolumeBuilder builder = new VolumeBuilder(item);_visitables.get("volumes").add(builder);this.volumes.add(builder);} return (A)this;
  }
  
  public A addAllToVolumes(Collection<Volume> items) {
    if (this.volumes == null) {this.volumes = new ArrayList<VolumeBuilder>();}
    for (Volume item : items) {VolumeBuilder builder = new VolumeBuilder(item);_visitables.get("volumes").add(builder);this.volumes.add(builder);} return (A)this;
  }
  
  public A removeFromVolumes(io.fabric8.kubernetes.api.model.Volume... items) {
    if (this.volumes == null) return (A)this;
    for (Volume item : items) {VolumeBuilder builder = new VolumeBuilder(item);_visitables.get("volumes").remove(builder); this.volumes.remove(builder);} return (A)this;
  }
  
  public A removeAllFromVolumes(Collection<Volume> items) {
    if (this.volumes == null) return (A)this;
    for (Volume item : items) {VolumeBuilder builder = new VolumeBuilder(item);_visitables.get("volumes").remove(builder); this.volumes.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromVolumes(Predicate<VolumeBuilder> predicate) {
    if (volumes == null) return (A) this;
    final Iterator<VolumeBuilder> each = volumes.iterator();
    final List visitables = _visitables.get("volumes");
    while (each.hasNext()) {
      VolumeBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<Volume> buildVolumes() {
    return this.volumes != null ? build(volumes) : null;
  }
  
  public Volume buildVolume(int index) {
    return this.volumes.get(index).build();
  }
  
  public Volume buildFirstVolume() {
    return this.volumes.get(0).build();
  }
  
  public Volume buildLastVolume() {
    return this.volumes.get(volumes.size() - 1).build();
  }
  
  public Volume buildMatchingVolume(Predicate<VolumeBuilder> predicate) {
      for (VolumeBuilder item : volumes) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingVolume(Predicate<VolumeBuilder> predicate) {
      for (VolumeBuilder item : volumes) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withVolumes(List<Volume> volumes) {
    if (this.volumes != null) {
      this._visitables.get("volumes").clear();
    }
    if (volumes != null) {
        this.volumes = new ArrayList();
        for (Volume item : volumes) {
          this.addToVolumes(item);
        }
    } else {
      this.volumes = null;
    }
    return (A) this;
  }
  
  public A withVolumes(io.fabric8.kubernetes.api.model.Volume... volumes) {
    if (this.volumes != null) {
        this.volumes.clear();
        _visitables.remove("volumes");
    }
    if (volumes != null) {
      for (Volume item : volumes) {
        this.addToVolumes(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasVolumes() {
    return this.volumes != null && !this.volumes.isEmpty();
  }
  
  public VolumesNested<A> addNewVolume() {
    return new VolumesNested(-1, null);
  }
  
  public VolumesNested<A> addNewVolumeLike(Volume item) {
    return new VolumesNested(-1, item);
  }
  
  public VolumesNested<A> setNewVolumeLike(int index,Volume item) {
    return new VolumesNested(index, item);
  }
  
  public VolumesNested<A> editVolume(int index) {
    if (volumes.size() <= index) throw new RuntimeException("Can't edit volumes. Index exceeds size.");
    return setNewVolumeLike(index, buildVolume(index));
  }
  
  public VolumesNested<A> editFirstVolume() {
    if (volumes.size() == 0) throw new RuntimeException("Can't edit first volumes. The list is empty.");
    return setNewVolumeLike(0, buildVolume(0));
  }
  
  public VolumesNested<A> editLastVolume() {
    int index = volumes.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last volumes. The list is empty.");
    return setNewVolumeLike(index, buildVolume(index));
  }
  
  public VolumesNested<A> editMatchingVolume(Predicate<VolumeBuilder> predicate) {
    int index = -1;
    for (int i=0;i<volumes.size();i++) { 
    if (predicate.test(volumes.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching volumes. No match found.");
    return setNewVolumeLike(index, buildVolume(index));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    TaskFluent that = (TaskFluent) o;
    if (!java.util.Objects.equals(container, that.container)) return false;
    if (!java.util.Objects.equals(volumes, that.volumes)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(container,  volumes,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (container != null) { sb.append("container:"); sb.append(container + ","); }
    if (volumes != null && !volumes.isEmpty()) { sb.append("volumes:"); sb.append(volumes + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class ContainerNested<N> extends ContainerFluent<ContainerNested<N>> implements Nested<N>{
    ContainerNested(Container item) {
      this.builder = new ContainerBuilder(this, item);
    }
    ContainerBuilder builder;
    
    public N and() {
      return (N) TaskFluent.this.withContainer(builder.build());
    }
    
    public N endContainer() {
      return and();
    }
    
  
  }
  public class VolumesNested<N> extends VolumeFluent<VolumesNested<N>> implements Nested<N>{
    VolumesNested(int index,Volume item) {
      this.index = index;
      this.builder = new VolumeBuilder(this, item);
    }
    VolumeBuilder builder;
    int index;
    
    public N and() {
      return (N) TaskFluent.this.setToVolumes(index,builder.build());
    }
    
    public N endVolume() {
      return and();
    }
    
  
  }

}