package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class StressorsBuilder extends StressorsFluent<StressorsBuilder> implements VisitableBuilder<Stressors,StressorsBuilder>{
  public StressorsBuilder() {
    this(new Stressors());
  }
  
  public StressorsBuilder(StressorsFluent<?> fluent) {
    this(fluent, new Stressors());
  }
  
  public StressorsBuilder(StressorsFluent<?> fluent,Stressors instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public StressorsBuilder(Stressors instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  StressorsFluent<?> fluent;
  
  public Stressors build() {
    Stressors buildable = new Stressors(fluent.buildCpu(),fluent.buildMemory());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}