package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class StressorBuilder extends StressorFluent<StressorBuilder> implements VisitableBuilder<Stressor,StressorBuilder>{
  public StressorBuilder() {
    this(new Stressor());
  }
  
  public StressorBuilder(StressorFluent<?> fluent) {
    this(fluent, new Stressor());
  }
  
  public StressorBuilder(StressorFluent<?> fluent,Stressor instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public StressorBuilder(Stressor instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  StressorFluent<?> fluent;
  
  public Stressor build() {
    Stressor buildable = new Stressor(fluent.getWorkers());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}