package io.fabric8.chaosmesh.v1alpha1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class StressChaosSpecFluent<A extends StressChaosSpecFluent<A>> extends BaseFluent<A>{
  public StressChaosSpecFluent() {
  }
  
  public StressChaosSpecFluent(StressChaosSpec instance) {
    this.copyInstance(instance);
  }
  private List<String> containerNames = new ArrayList<String>();
  private String duration;
  private String mode;
  private String remoteCluster;
  private PodSelectorSpecBuilder selector;
  private String stressngStressors;
  private StressorsBuilder stressors;
  private String value;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(StressChaosSpec instance) {
    instance = (instance != null ? instance : new StressChaosSpec());
    if (instance != null) {
          this.withContainerNames(instance.getContainerNames());
          this.withDuration(instance.getDuration());
          this.withMode(instance.getMode());
          this.withRemoteCluster(instance.getRemoteCluster());
          this.withSelector(instance.getSelector());
          this.withStressngStressors(instance.getStressngStressors());
          this.withStressors(instance.getStressors());
          this.withValue(instance.getValue());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public A addToContainerNames(int index,String item) {
    if (this.containerNames == null) {this.containerNames = new ArrayList<String>();}
    this.containerNames.add(index, item);
    return (A)this;
  }
  
  public A setToContainerNames(int index,String item) {
    if (this.containerNames == null) {this.containerNames = new ArrayList<String>();}
    this.containerNames.set(index, item); return (A)this;
  }
  
  public A addToContainerNames(java.lang.String... items) {
    if (this.containerNames == null) {this.containerNames = new ArrayList<String>();}
    for (String item : items) {this.containerNames.add(item);} return (A)this;
  }
  
  public A addAllToContainerNames(Collection<String> items) {
    if (this.containerNames == null) {this.containerNames = new ArrayList<String>();}
    for (String item : items) {this.containerNames.add(item);} return (A)this;
  }
  
  public A removeFromContainerNames(java.lang.String... items) {
    if (this.containerNames == null) return (A)this;
    for (String item : items) { this.containerNames.remove(item);} return (A)this;
  }
  
  public A removeAllFromContainerNames(Collection<String> items) {
    if (this.containerNames == null) return (A)this;
    for (String item : items) { this.containerNames.remove(item);} return (A)this;
  }
  
  public List<String> getContainerNames() {
    return this.containerNames;
  }
  
  public String getContainerName(int index) {
    return this.containerNames.get(index);
  }
  
  public String getFirstContainerName() {
    return this.containerNames.get(0);
  }
  
  public String getLastContainerName() {
    return this.containerNames.get(containerNames.size() - 1);
  }
  
  public String getMatchingContainerName(Predicate<String> predicate) {
      for (String item : containerNames) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingContainerName(Predicate<String> predicate) {
      for (String item : containerNames) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withContainerNames(List<String> containerNames) {
    if (containerNames != null) {
        this.containerNames = new ArrayList();
        for (String item : containerNames) {
          this.addToContainerNames(item);
        }
    } else {
      this.containerNames = null;
    }
    return (A) this;
  }
  
  public A withContainerNames(java.lang.String... containerNames) {
    if (this.containerNames != null) {
        this.containerNames.clear();
        _visitables.remove("containerNames");
    }
    if (containerNames != null) {
      for (String item : containerNames) {
        this.addToContainerNames(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasContainerNames() {
    return this.containerNames != null && !this.containerNames.isEmpty();
  }
  
  public String getDuration() {
    return this.duration;
  }
  
  public A withDuration(String duration) {
    this.duration = duration;
    return (A) this;
  }
  
  public boolean hasDuration() {
    return this.duration != null;
  }
  
  public String getMode() {
    return this.mode;
  }
  
  public A withMode(String mode) {
    this.mode = mode;
    return (A) this;
  }
  
  public boolean hasMode() {
    return this.mode != null;
  }
  
  public String getRemoteCluster() {
    return this.remoteCluster;
  }
  
  public A withRemoteCluster(String remoteCluster) {
    this.remoteCluster = remoteCluster;
    return (A) this;
  }
  
  public boolean hasRemoteCluster() {
    return this.remoteCluster != null;
  }
  
  public PodSelectorSpec buildSelector() {
    return this.selector != null ? this.selector.build() : null;
  }
  
  public A withSelector(PodSelectorSpec selector) {
    this._visitables.remove("selector");
    if (selector != null) {
        this.selector = new PodSelectorSpecBuilder(selector);
        this._visitables.get("selector").add(this.selector);
    } else {
        this.selector = null;
        this._visitables.get("selector").remove(this.selector);
    }
    return (A) this;
  }
  
  public boolean hasSelector() {
    return this.selector != null;
  }
  
  public SelectorNested<A> withNewSelector() {
    return new SelectorNested(null);
  }
  
  public SelectorNested<A> withNewSelectorLike(PodSelectorSpec item) {
    return new SelectorNested(item);
  }
  
  public SelectorNested<A> editSelector() {
    return withNewSelectorLike(java.util.Optional.ofNullable(buildSelector()).orElse(null));
  }
  
  public SelectorNested<A> editOrNewSelector() {
    return withNewSelectorLike(java.util.Optional.ofNullable(buildSelector()).orElse(new PodSelectorSpecBuilder().build()));
  }
  
  public SelectorNested<A> editOrNewSelectorLike(PodSelectorSpec item) {
    return withNewSelectorLike(java.util.Optional.ofNullable(buildSelector()).orElse(item));
  }
  
  public String getStressngStressors() {
    return this.stressngStressors;
  }
  
  public A withStressngStressors(String stressngStressors) {
    this.stressngStressors = stressngStressors;
    return (A) this;
  }
  
  public boolean hasStressngStressors() {
    return this.stressngStressors != null;
  }
  
  public Stressors buildStressors() {
    return this.stressors != null ? this.stressors.build() : null;
  }
  
  public A withStressors(Stressors stressors) {
    this._visitables.remove("stressors");
    if (stressors != null) {
        this.stressors = new StressorsBuilder(stressors);
        this._visitables.get("stressors").add(this.stressors);
    } else {
        this.stressors = null;
        this._visitables.get("stressors").remove(this.stressors);
    }
    return (A) this;
  }
  
  public boolean hasStressors() {
    return this.stressors != null;
  }
  
  public StressorsNested<A> withNewStressors() {
    return new StressorsNested(null);
  }
  
  public StressorsNested<A> withNewStressorsLike(Stressors item) {
    return new StressorsNested(item);
  }
  
  public StressorsNested<A> editStressors() {
    return withNewStressorsLike(java.util.Optional.ofNullable(buildStressors()).orElse(null));
  }
  
  public StressorsNested<A> editOrNewStressors() {
    return withNewStressorsLike(java.util.Optional.ofNullable(buildStressors()).orElse(new StressorsBuilder().build()));
  }
  
  public StressorsNested<A> editOrNewStressorsLike(Stressors item) {
    return withNewStressorsLike(java.util.Optional.ofNullable(buildStressors()).orElse(item));
  }
  
  public String getValue() {
    return this.value;
  }
  
  public A withValue(String value) {
    this.value = value;
    return (A) this;
  }
  
  public boolean hasValue() {
    return this.value != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    StressChaosSpecFluent that = (StressChaosSpecFluent) o;
    if (!java.util.Objects.equals(containerNames, that.containerNames)) return false;
    if (!java.util.Objects.equals(duration, that.duration)) return false;
    if (!java.util.Objects.equals(mode, that.mode)) return false;
    if (!java.util.Objects.equals(remoteCluster, that.remoteCluster)) return false;
    if (!java.util.Objects.equals(selector, that.selector)) return false;
    if (!java.util.Objects.equals(stressngStressors, that.stressngStressors)) return false;
    if (!java.util.Objects.equals(stressors, that.stressors)) return false;
    if (!java.util.Objects.equals(value, that.value)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(containerNames,  duration,  mode,  remoteCluster,  selector,  stressngStressors,  stressors,  value,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (containerNames != null && !containerNames.isEmpty()) { sb.append("containerNames:"); sb.append(containerNames + ","); }
    if (duration != null) { sb.append("duration:"); sb.append(duration + ","); }
    if (mode != null) { sb.append("mode:"); sb.append(mode + ","); }
    if (remoteCluster != null) { sb.append("remoteCluster:"); sb.append(remoteCluster + ","); }
    if (selector != null) { sb.append("selector:"); sb.append(selector + ","); }
    if (stressngStressors != null) { sb.append("stressngStressors:"); sb.append(stressngStressors + ","); }
    if (stressors != null) { sb.append("stressors:"); sb.append(stressors + ","); }
    if (value != null) { sb.append("value:"); sb.append(value + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class SelectorNested<N> extends PodSelectorSpecFluent<SelectorNested<N>> implements Nested<N>{
    SelectorNested(PodSelectorSpec item) {
      this.builder = new PodSelectorSpecBuilder(this, item);
    }
    PodSelectorSpecBuilder builder;
    
    public N and() {
      return (N) StressChaosSpecFluent.this.withSelector(builder.build());
    }
    
    public N endSelector() {
      return and();
    }
    
  
  }
  public class StressorsNested<N> extends StressorsFluent<StressorsNested<N>> implements Nested<N>{
    StressorsNested(Stressors item) {
      this.builder = new StressorsBuilder(this, item);
    }
    StressorsBuilder builder;
    
    public N and() {
      return (N) StressChaosSpecFluent.this.withStressors(builder.build());
    }
    
    public N endStressors() {
      return and();
    }
    
  
  }

}