package io.fabric8.chaosmesh.v1alpha1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Integer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class StatusCheckSpecFluent<A extends StatusCheckSpecFluent<A>> extends BaseFluent<A>{
  public StatusCheckSpecFluent() {
  }
  
  public StatusCheckSpecFluent(StatusCheckSpec instance) {
    this.copyInstance(instance);
  }
  private String duration;
  private Integer failureThreshold;
  private HTTPStatusCheckBuilder http;
  private Integer intervalSeconds;
  private String mode;
  private Integer recordsHistoryLimit;
  private Integer successThreshold;
  private Integer timeoutSeconds;
  private String type;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(StatusCheckSpec instance) {
    instance = (instance != null ? instance : new StatusCheckSpec());
    if (instance != null) {
          this.withDuration(instance.getDuration());
          this.withFailureThreshold(instance.getFailureThreshold());
          this.withHttp(instance.getHttp());
          this.withIntervalSeconds(instance.getIntervalSeconds());
          this.withMode(instance.getMode());
          this.withRecordsHistoryLimit(instance.getRecordsHistoryLimit());
          this.withSuccessThreshold(instance.getSuccessThreshold());
          this.withTimeoutSeconds(instance.getTimeoutSeconds());
          this.withType(instance.getType());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public String getDuration() {
    return this.duration;
  }
  
  public A withDuration(String duration) {
    this.duration = duration;
    return (A) this;
  }
  
  public boolean hasDuration() {
    return this.duration != null;
  }
  
  public Integer getFailureThreshold() {
    return this.failureThreshold;
  }
  
  public A withFailureThreshold(Integer failureThreshold) {
    this.failureThreshold = failureThreshold;
    return (A) this;
  }
  
  public boolean hasFailureThreshold() {
    return this.failureThreshold != null;
  }
  
  public HTTPStatusCheck buildHttp() {
    return this.http != null ? this.http.build() : null;
  }
  
  public A withHttp(HTTPStatusCheck http) {
    this._visitables.remove("http");
    if (http != null) {
        this.http = new HTTPStatusCheckBuilder(http);
        this._visitables.get("http").add(this.http);
    } else {
        this.http = null;
        this._visitables.get("http").remove(this.http);
    }
    return (A) this;
  }
  
  public boolean hasHttp() {
    return this.http != null;
  }
  
  public HttpNested<A> withNewHttp() {
    return new HttpNested(null);
  }
  
  public HttpNested<A> withNewHttpLike(HTTPStatusCheck item) {
    return new HttpNested(item);
  }
  
  public HttpNested<A> editHttp() {
    return withNewHttpLike(java.util.Optional.ofNullable(buildHttp()).orElse(null));
  }
  
  public HttpNested<A> editOrNewHttp() {
    return withNewHttpLike(java.util.Optional.ofNullable(buildHttp()).orElse(new HTTPStatusCheckBuilder().build()));
  }
  
  public HttpNested<A> editOrNewHttpLike(HTTPStatusCheck item) {
    return withNewHttpLike(java.util.Optional.ofNullable(buildHttp()).orElse(item));
  }
  
  public Integer getIntervalSeconds() {
    return this.intervalSeconds;
  }
  
  public A withIntervalSeconds(Integer intervalSeconds) {
    this.intervalSeconds = intervalSeconds;
    return (A) this;
  }
  
  public boolean hasIntervalSeconds() {
    return this.intervalSeconds != null;
  }
  
  public String getMode() {
    return this.mode;
  }
  
  public A withMode(String mode) {
    this.mode = mode;
    return (A) this;
  }
  
  public boolean hasMode() {
    return this.mode != null;
  }
  
  public Integer getRecordsHistoryLimit() {
    return this.recordsHistoryLimit;
  }
  
  public A withRecordsHistoryLimit(Integer recordsHistoryLimit) {
    this.recordsHistoryLimit = recordsHistoryLimit;
    return (A) this;
  }
  
  public boolean hasRecordsHistoryLimit() {
    return this.recordsHistoryLimit != null;
  }
  
  public Integer getSuccessThreshold() {
    return this.successThreshold;
  }
  
  public A withSuccessThreshold(Integer successThreshold) {
    this.successThreshold = successThreshold;
    return (A) this;
  }
  
  public boolean hasSuccessThreshold() {
    return this.successThreshold != null;
  }
  
  public Integer getTimeoutSeconds() {
    return this.timeoutSeconds;
  }
  
  public A withTimeoutSeconds(Integer timeoutSeconds) {
    this.timeoutSeconds = timeoutSeconds;
    return (A) this;
  }
  
  public boolean hasTimeoutSeconds() {
    return this.timeoutSeconds != null;
  }
  
  public String getType() {
    return this.type;
  }
  
  public A withType(String type) {
    this.type = type;
    return (A) this;
  }
  
  public boolean hasType() {
    return this.type != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    StatusCheckSpecFluent that = (StatusCheckSpecFluent) o;
    if (!java.util.Objects.equals(duration, that.duration)) return false;
    if (!java.util.Objects.equals(failureThreshold, that.failureThreshold)) return false;
    if (!java.util.Objects.equals(http, that.http)) return false;
    if (!java.util.Objects.equals(intervalSeconds, that.intervalSeconds)) return false;
    if (!java.util.Objects.equals(mode, that.mode)) return false;
    if (!java.util.Objects.equals(recordsHistoryLimit, that.recordsHistoryLimit)) return false;
    if (!java.util.Objects.equals(successThreshold, that.successThreshold)) return false;
    if (!java.util.Objects.equals(timeoutSeconds, that.timeoutSeconds)) return false;
    if (!java.util.Objects.equals(type, that.type)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(duration,  failureThreshold,  http,  intervalSeconds,  mode,  recordsHistoryLimit,  successThreshold,  timeoutSeconds,  type,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (duration != null) { sb.append("duration:"); sb.append(duration + ","); }
    if (failureThreshold != null) { sb.append("failureThreshold:"); sb.append(failureThreshold + ","); }
    if (http != null) { sb.append("http:"); sb.append(http + ","); }
    if (intervalSeconds != null) { sb.append("intervalSeconds:"); sb.append(intervalSeconds + ","); }
    if (mode != null) { sb.append("mode:"); sb.append(mode + ","); }
    if (recordsHistoryLimit != null) { sb.append("recordsHistoryLimit:"); sb.append(recordsHistoryLimit + ","); }
    if (successThreshold != null) { sb.append("successThreshold:"); sb.append(successThreshold + ","); }
    if (timeoutSeconds != null) { sb.append("timeoutSeconds:"); sb.append(timeoutSeconds + ","); }
    if (type != null) { sb.append("type:"); sb.append(type + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class HttpNested<N> extends HTTPStatusCheckFluent<HttpNested<N>> implements Nested<N>{
    HttpNested(HTTPStatusCheck item) {
      this.builder = new HTTPStatusCheckBuilder(this, item);
    }
    HTTPStatusCheckBuilder builder;
    
    public N and() {
      return (N) StatusCheckSpecFluent.this.withHttp(builder.build());
    }
    
    public N endHttp() {
      return and();
    }
    
  
  }

}