
package io.fabric8.chaosmesh.v1alpha1;

import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.processing.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.builder.Editable;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerPort;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.IntOrString;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaim;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import io.fabric8.kubernetes.api.model.Volume;
import io.fabric8.kubernetes.api.model.VolumeMount;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import lombok.experimental.Accessors;

@JsonDeserialize(using = com.fasterxml.jackson.databind.JsonDeserializer.None.class)
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "addr",
    "conf",
    "flushConfig",
    "password",
    "redisPath"
})
@ToString
@EqualsAndHashCode
@Accessors(prefix = {
    "_",
    ""
})
@Buildable(editableEnabled = false, validationEnabled = false, generateBuilderPackage = false, lazyCollectionInitEnabled = false, builderPackage = "io.fabric8.kubernetes.api.builder", refs = {
    @BuildableReference(ObjectMeta.class),
    @BuildableReference(LabelSelector.class),
    @BuildableReference(Container.class),
    @BuildableReference(PodTemplateSpec.class),
    @BuildableReference(ResourceRequirements.class),
    @BuildableReference(IntOrString.class),
    @BuildableReference(ObjectReference.class),
    @BuildableReference(LocalObjectReference.class),
    @BuildableReference(PersistentVolumeClaim.class),
    @BuildableReference(EnvVar.class),
    @BuildableReference(ContainerPort.class),
    @BuildableReference(Volume.class),
    @BuildableReference(VolumeMount.class)
})
@Generated("io.fabric8.kubernetes.schema.generator.model.ModelGenerator")
public class RedisSentinelRestartSpec implements Editable<RedisSentinelRestartSpecBuilder>, KubernetesResource
{

    @JsonProperty("addr")
    private String addr;
    @JsonProperty("conf")
    private String conf;
    @JsonProperty("flushConfig")
    private Boolean flushConfig;
    @JsonProperty("password")
    private String password;
    @JsonProperty("redisPath")
    private Boolean redisPath;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();

    /**
     * No args constructor for use in serialization
     */
    public RedisSentinelRestartSpec() {
    }

    public RedisSentinelRestartSpec(String addr, String conf, Boolean flushConfig, String password, Boolean redisPath) {
        super();
        this.addr = addr;
        this.conf = conf;
        this.flushConfig = flushConfig;
        this.password = password;
        this.redisPath = redisPath;
    }

    /**
     * The adress of Redis server
     */
    @JsonProperty("addr")
    public String getAddr() {
        return addr;
    }

    /**
     * The adress of Redis server
     */
    @JsonProperty("addr")
    public void setAddr(String addr) {
        this.addr = addr;
    }

    /**
     * The path of Sentinel conf
     */
    @JsonProperty("conf")
    public String getConf() {
        return conf;
    }

    /**
     * The path of Sentinel conf
     */
    @JsonProperty("conf")
    public void setConf(String conf) {
        this.conf = conf;
    }

    /**
     * The control flag determines whether to flush config
     */
    @JsonProperty("flushConfig")
    public Boolean getFlushConfig() {
        return flushConfig;
    }

    /**
     * The control flag determines whether to flush config
     */
    @JsonProperty("flushConfig")
    public void setFlushConfig(Boolean flushConfig) {
        this.flushConfig = flushConfig;
    }

    /**
     * The password of Redis server
     */
    @JsonProperty("password")
    public String getPassword() {
        return password;
    }

    /**
     * The password of Redis server
     */
    @JsonProperty("password")
    public void setPassword(String password) {
        this.password = password;
    }

    /**
     * The path of `redis-server` command-line tool
     */
    @JsonProperty("redisPath")
    public Boolean getRedisPath() {
        return redisPath;
    }

    /**
     * The path of `redis-server` command-line tool
     */
    @JsonProperty("redisPath")
    public void setRedisPath(Boolean redisPath) {
        this.redisPath = redisPath;
    }

    @JsonIgnore
    public RedisSentinelRestartSpecBuilder edit() {
        return new RedisSentinelRestartSpecBuilder(this);
    }

    @JsonIgnore
    public RedisSentinelRestartSpecBuilder toBuilder() {
        return edit();
    }

    @JsonAnyGetter
    @JsonIgnore
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public void setAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
    }

}
