package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class RedisCommonSpecBuilder extends RedisCommonSpecFluent<RedisCommonSpecBuilder> implements VisitableBuilder<RedisCommonSpec,RedisCommonSpecBuilder>{
  public RedisCommonSpecBuilder() {
    this(new RedisCommonSpec());
  }
  
  public RedisCommonSpecBuilder(RedisCommonSpecFluent<?> fluent) {
    this(fluent, new RedisCommonSpec());
  }
  
  public RedisCommonSpecBuilder(RedisCommonSpecFluent<?> fluent,RedisCommonSpec instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public RedisCommonSpecBuilder(RedisCommonSpec instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  RedisCommonSpecFluent<?> fluent;
  
  public RedisCommonSpec build() {
    RedisCommonSpec buildable = new RedisCommonSpec(fluent.getAddr(),fluent.getPassword());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}