package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class RedisCacheLimitSpecBuilder extends RedisCacheLimitSpecFluent<RedisCacheLimitSpecBuilder> implements VisitableBuilder<RedisCacheLimitSpec,RedisCacheLimitSpecBuilder>{
  public RedisCacheLimitSpecBuilder() {
    this(new RedisCacheLimitSpec());
  }
  
  public RedisCacheLimitSpecBuilder(RedisCacheLimitSpecFluent<?> fluent) {
    this(fluent, new RedisCacheLimitSpec());
  }
  
  public RedisCacheLimitSpecBuilder(RedisCacheLimitSpecFluent<?> fluent,RedisCacheLimitSpec instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public RedisCacheLimitSpecBuilder(RedisCacheLimitSpec instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  RedisCacheLimitSpecFluent<?> fluent;
  
  public RedisCacheLimitSpec build() {
    RedisCacheLimitSpec buildable = new RedisCacheLimitSpec(fluent.getAddr(),fluent.getCacheSize(),fluent.getPassword(),fluent.getPercent());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}