package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class RecordFluent<A extends RecordFluent<A>> extends BaseFluent<A>{
  public RecordFluent() {
  }
  
  public RecordFluent(Record instance) {
    this.copyInstance(instance);
  }
  private ArrayList<RecordEventBuilder> events = new ArrayList<RecordEventBuilder>();
  private String id;
  private Integer injectedCount;
  private String phase;
  private Integer recoveredCount;
  private String selectorKey;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(Record instance) {
    instance = (instance != null ? instance : new Record());
    if (instance != null) {
          this.withEvents(instance.getEvents());
          this.withId(instance.getId());
          this.withInjectedCount(instance.getInjectedCount());
          this.withPhase(instance.getPhase());
          this.withRecoveredCount(instance.getRecoveredCount());
          this.withSelectorKey(instance.getSelectorKey());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public A addToEvents(int index,RecordEvent item) {
    if (this.events == null) {this.events = new ArrayList<RecordEventBuilder>();}
    RecordEventBuilder builder = new RecordEventBuilder(item);
    if (index < 0 || index >= events.size()) {
        _visitables.get("events").add(builder);
        events.add(builder);
    } else {
        _visitables.get("events").add(builder);
        events.add(index, builder);
    }
    return (A)this;
  }
  
  public A setToEvents(int index,RecordEvent item) {
    if (this.events == null) {this.events = new ArrayList<RecordEventBuilder>();}
    RecordEventBuilder builder = new RecordEventBuilder(item);
    if (index < 0 || index >= events.size()) {
        _visitables.get("events").add(builder);
        events.add(builder);
    } else {
        _visitables.get("events").add(builder);
        events.set(index, builder);
    }
    return (A)this;
  }
  
  public A addToEvents(io.fabric8.chaosmesh.v1alpha1.RecordEvent... items) {
    if (this.events == null) {this.events = new ArrayList<RecordEventBuilder>();}
    for (RecordEvent item : items) {RecordEventBuilder builder = new RecordEventBuilder(item);_visitables.get("events").add(builder);this.events.add(builder);} return (A)this;
  }
  
  public A addAllToEvents(Collection<RecordEvent> items) {
    if (this.events == null) {this.events = new ArrayList<RecordEventBuilder>();}
    for (RecordEvent item : items) {RecordEventBuilder builder = new RecordEventBuilder(item);_visitables.get("events").add(builder);this.events.add(builder);} return (A)this;
  }
  
  public A removeFromEvents(io.fabric8.chaosmesh.v1alpha1.RecordEvent... items) {
    if (this.events == null) return (A)this;
    for (RecordEvent item : items) {RecordEventBuilder builder = new RecordEventBuilder(item);_visitables.get("events").remove(builder); this.events.remove(builder);} return (A)this;
  }
  
  public A removeAllFromEvents(Collection<RecordEvent> items) {
    if (this.events == null) return (A)this;
    for (RecordEvent item : items) {RecordEventBuilder builder = new RecordEventBuilder(item);_visitables.get("events").remove(builder); this.events.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromEvents(Predicate<RecordEventBuilder> predicate) {
    if (events == null) return (A) this;
    final Iterator<RecordEventBuilder> each = events.iterator();
    final List visitables = _visitables.get("events");
    while (each.hasNext()) {
      RecordEventBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<RecordEvent> buildEvents() {
    return this.events != null ? build(events) : null;
  }
  
  public RecordEvent buildEvent(int index) {
    return this.events.get(index).build();
  }
  
  public RecordEvent buildFirstEvent() {
    return this.events.get(0).build();
  }
  
  public RecordEvent buildLastEvent() {
    return this.events.get(events.size() - 1).build();
  }
  
  public RecordEvent buildMatchingEvent(Predicate<RecordEventBuilder> predicate) {
      for (RecordEventBuilder item : events) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingEvent(Predicate<RecordEventBuilder> predicate) {
      for (RecordEventBuilder item : events) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withEvents(List<RecordEvent> events) {
    if (this.events != null) {
      this._visitables.get("events").clear();
    }
    if (events != null) {
        this.events = new ArrayList();
        for (RecordEvent item : events) {
          this.addToEvents(item);
        }
    } else {
      this.events = null;
    }
    return (A) this;
  }
  
  public A withEvents(io.fabric8.chaosmesh.v1alpha1.RecordEvent... events) {
    if (this.events != null) {
        this.events.clear();
        _visitables.remove("events");
    }
    if (events != null) {
      for (RecordEvent item : events) {
        this.addToEvents(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasEvents() {
    return this.events != null && !this.events.isEmpty();
  }
  
  public A addNewEvent(String message,String operation,String timestamp,String type) {
    return (A)addToEvents(new RecordEvent(message, operation, timestamp, type));
  }
  
  public EventsNested<A> addNewEvent() {
    return new EventsNested(-1, null);
  }
  
  public EventsNested<A> addNewEventLike(RecordEvent item) {
    return new EventsNested(-1, item);
  }
  
  public EventsNested<A> setNewEventLike(int index,RecordEvent item) {
    return new EventsNested(index, item);
  }
  
  public EventsNested<A> editEvent(int index) {
    if (events.size() <= index) throw new RuntimeException("Can't edit events. Index exceeds size.");
    return setNewEventLike(index, buildEvent(index));
  }
  
  public EventsNested<A> editFirstEvent() {
    if (events.size() == 0) throw new RuntimeException("Can't edit first events. The list is empty.");
    return setNewEventLike(0, buildEvent(0));
  }
  
  public EventsNested<A> editLastEvent() {
    int index = events.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last events. The list is empty.");
    return setNewEventLike(index, buildEvent(index));
  }
  
  public EventsNested<A> editMatchingEvent(Predicate<RecordEventBuilder> predicate) {
    int index = -1;
    for (int i=0;i<events.size();i++) { 
    if (predicate.test(events.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching events. No match found.");
    return setNewEventLike(index, buildEvent(index));
  }
  
  public String getId() {
    return this.id;
  }
  
  public A withId(String id) {
    this.id = id;
    return (A) this;
  }
  
  public boolean hasId() {
    return this.id != null;
  }
  
  public Integer getInjectedCount() {
    return this.injectedCount;
  }
  
  public A withInjectedCount(Integer injectedCount) {
    this.injectedCount = injectedCount;
    return (A) this;
  }
  
  public boolean hasInjectedCount() {
    return this.injectedCount != null;
  }
  
  public String getPhase() {
    return this.phase;
  }
  
  public A withPhase(String phase) {
    this.phase = phase;
    return (A) this;
  }
  
  public boolean hasPhase() {
    return this.phase != null;
  }
  
  public Integer getRecoveredCount() {
    return this.recoveredCount;
  }
  
  public A withRecoveredCount(Integer recoveredCount) {
    this.recoveredCount = recoveredCount;
    return (A) this;
  }
  
  public boolean hasRecoveredCount() {
    return this.recoveredCount != null;
  }
  
  public String getSelectorKey() {
    return this.selectorKey;
  }
  
  public A withSelectorKey(String selectorKey) {
    this.selectorKey = selectorKey;
    return (A) this;
  }
  
  public boolean hasSelectorKey() {
    return this.selectorKey != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    RecordFluent that = (RecordFluent) o;
    if (!java.util.Objects.equals(events, that.events)) return false;
    if (!java.util.Objects.equals(id, that.id)) return false;
    if (!java.util.Objects.equals(injectedCount, that.injectedCount)) return false;
    if (!java.util.Objects.equals(phase, that.phase)) return false;
    if (!java.util.Objects.equals(recoveredCount, that.recoveredCount)) return false;
    if (!java.util.Objects.equals(selectorKey, that.selectorKey)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(events,  id,  injectedCount,  phase,  recoveredCount,  selectorKey,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (events != null && !events.isEmpty()) { sb.append("events:"); sb.append(events + ","); }
    if (id != null) { sb.append("id:"); sb.append(id + ","); }
    if (injectedCount != null) { sb.append("injectedCount:"); sb.append(injectedCount + ","); }
    if (phase != null) { sb.append("phase:"); sb.append(phase + ","); }
    if (recoveredCount != null) { sb.append("recoveredCount:"); sb.append(recoveredCount + ","); }
    if (selectorKey != null) { sb.append("selectorKey:"); sb.append(selectorKey + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class EventsNested<N> extends RecordEventFluent<EventsNested<N>> implements Nested<N>{
    EventsNested(int index,RecordEvent item) {
      this.index = index;
      this.builder = new RecordEventBuilder(this, item);
    }
    RecordEventBuilder builder;
    int index;
    
    public N and() {
      return (N) RecordFluent.this.setToEvents(index,builder.build());
    }
    
    public N endEvent() {
      return and();
    }
    
  
  }

}